/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomai.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class TestListener
implements ITestListener {
    private static Logger logger = Logger.getLogger(String.valueOf(ITestListener.class));

    public void onFinish(ITestContext testContext) {
        ArrayList<ITestResult> testsToBeRemoved = new ArrayList<ITestResult>();
        HashSet<Integer> passedTestIds = new HashSet<Integer>();
        for (Object passedTest : testContext.getPassedTests().getAllResults()) {
            logger.info("PassedTests = " + passedTest.getName());
            passedTestIds.add(this.getId((ITestResult)passedTest));
        }
        HashSet<Integer> failedTestIds = new HashSet<Integer>();
        for (ITestResult failedTest : testContext.getFailedTests().getAllResults()) {
            logger.info("failedTest = " + failedTest.getName());
            int failedTestId = this.getId(failedTest);
            if (failedTestIds.contains(failedTestId) || passedTestIds.contains(failedTestId)) {
                testsToBeRemoved.add(failedTest);
                continue;
            }
            failedTestIds.add(failedTestId);
        }
        Iterator iterator = testContext.getFailedTests().getAllResults().iterator();
        while (iterator.hasNext()) {
            ITestResult testResult = (ITestResult)iterator.next();
            if (!testsToBeRemoved.contains(testResult)) continue;
            logger.info("Remove repeat Fail Test: " + testResult.getName());
            iterator.remove();
        }
    }

    private int getId(ITestResult result) {
        int id = result.getTestClass().getName().hashCode();
        id += result.getMethod().getMethodName().hashCode();
        return id += result.getParameters() != null ? Arrays.hashCode(result.getParameters()) : 0;
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult result) {
    }

    public void onTestFailure(ITestResult result) {
    }

    public void onTestSkipped(ITestResult result) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onStart(ITestContext context) {
    }
}

