/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomai.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class TimeUtils {
    private static Date praseDate(String time, SimpleDateFormat sdf) {
        try {
            return sdf.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getToDayTime(int hour, int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, 0);
        long data = calendar.getTime().getTime();
        return data;
    }

    public static long getTodayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        long today_date = calendar.getTime().getTime();
        return today_date;
    }

    public static long getTodayEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        long today_end_date = calendar.getTime().getTime();
        return today_end_date;
    }

    public static long getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        long today_date = calendar.getTime().getTime();
        return today_date;
    }

    public static long getLastWeekDate() {
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c_1 = Calendar.getInstance();
        c_1.setTime(new Date());
        c_1.add(5, -7);
        Date d = c_1.getTime();
        String lastweek_day = sdf_day.format(d) + " 00:00:00";
        Date lastweek_date = null;
        lastweek_date = TimeUtils.praseDate(lastweek_day, sdf_hms);
        long lastweek_time = lastweek_date.getTime();
        return lastweek_time;
    }

    public static long getAfterDayDate(int addDay) {
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c_1 = Calendar.getInstance();
        c_1.setTime(new Date());
        c_1.add(5, addDay);
        Date d = c_1.getTime();
        String lastday_day = sdf_day.format(d) + " 23:59:59";
        Date lastday_date = null;
        lastday_date = TimeUtils.praseDate(lastday_day, sdf_hms);
        long afterday_time = lastday_date.getTime();
        return afterday_time;
    }

    public static long getAfterMonthDate(long sDate, int addMonth, int addDay) {
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date smdate = new Date(sDate);
        Calendar c_1 = Calendar.getInstance();
        c_1.setTime(smdate);
        c_1.add(2, addMonth);
        c_1.add(5, -1);
        c_1.add(5, addDay);
        Date lastweek_aftermonth_d = c_1.getTime();
        String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) + " 00:00:00";
        Date date_month = TimeUtils.praseDate(lastweek_aftermonth, sdf_hms);
        long time_month = date_month.getTime();
        return time_month;
    }

    public static long getLastrMonthDate(long sDate, int addMonth, int addDay) {
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date smdate = new Date(sDate);
        Calendar c_1 = Calendar.getInstance();
        c_1.setTime(smdate);
        c_1.add(2, -addMonth);
        c_1.add(5, -addDay);
        c_1.add(5, 1);
        Date lastweek_aftermonth_d = c_1.getTime();
        String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) + " 00:00:00";
        Date date_month = TimeUtils.praseDate(lastweek_aftermonth, sdf_hms);
        long time_month = date_month.getTime();
        return time_month;
    }

    public static long getMonthFristDay() {
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        Date lastweek_aftermonth_d = c.getTime();
        String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) + " 00:00:00";
        Date date_month = TimeUtils.praseDate(lastweek_aftermonth, sdf_hms);
        long time_month = date_month.getTime();
        return time_month;
    }

    public static long getMonthLastDay() {
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        Date lastweek_aftermonth_d = ca.getTime();
        String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) + " 00:00:00";
        Date date_month = TimeUtils.praseDate(lastweek_aftermonth, sdf_hms);
        long time_month = date_month.getTime();
        return time_month;
    }

    public static long getMonthLastTime() {
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        Date lastweek_aftermonth_d = ca.getTime();
        String lastweek_aftermonth = sdf_day.format(lastweek_aftermonth_d) + " 23:59:59";
        Date date_month = TimeUtils.praseDate(lastweek_aftermonth, sdf_hms);
        long time_month = date_month.getTime();
        return time_month;
    }

    public static String getWeekFirstTime() {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(2);
        cld.set(11, 0);
        cld.set(12, 0);
        cld.set(13, 0);
        cld.set(7, 2);
        String beginWeekTime = String.valueOf(cld.getTime().getTime());
        return beginWeekTime;
    }

    public static String getWeekLastTime() {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        int week = cld.get(7);
        cld.add(5, 8 - week);
        cld.set(11, 23);
        cld.set(12, 59);
        cld.set(13, 59);
        String endWeekTime = String.valueOf(cld.getTime().getTime());
        return endWeekTime;
    }

    public static int daysBetween(long time_s, long time_e) {
        long between_days = (time_e - time_s) / 86400000L;
        int daysBetween = Integer.parseInt(String.valueOf(between_days)) + 1;
        return Integer.parseInt(String.valueOf(daysBetween));
    }

    public static void main1(String[] args) {
        long todayDate = TimeUtils.getTodayTime();
        long lastWeekDate = TimeUtils.getLastWeekDate();
        long afterMonthDate = TimeUtils.getAfterMonthDate(lastWeekDate, 1, 2);
        long lastMonthDate = TimeUtils.getLastrMonthDate(lastWeekDate, 1, 2);
        int lastWeekDate_afterMonthDate = TimeUtils.daysBetween(lastWeekDate, afterMonthDate);
        int leftDays_1 = lastWeekDate_afterMonthDate - 7;
        int lastWeekDate_lastMonthDate = TimeUtils.daysBetween(lastMonthDate, lastWeekDate);
        System.out.println("\u4e0a\u5468\u5f80\u540e\u63a8\u4e00\u4e2a\u6708\u7684\u65e5\u671f  \u5230\u4e0a\u5468\u7684\u5929\u6570\u5dee\uff1a" + lastWeekDate_afterMonthDate);
        System.out.println("\u4e0a\u5468\u5f80\u524d\u63a8\u4e00\u4e2a\u6708\u7684\u65e5\u671f  \u5230\u4e0a\u5468\u7684\u5929\u6570\u5dee\uff1a" + lastWeekDate_lastMonthDate);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(2);
        cld.set(11, 0);
        cld.set(12, 0);
        cld.set(13, 0);
        cld.set(7, 2);
        long Monday_date = cld.getTime().getTime();
        System.out.println("\u672c\u5468\u5468\u4e00\uff1a" + df.format(cld.getTime()) + " --" + Monday_date);
        cld.set(7, 1);
        cld.set(11, 23);
        cld.set(12, 59);
        cld.set(13, 59);
        long Sunday_date = cld.getTime().getTime();
        System.out.println("\u672c\u5468\u5468\u65e5" + df.format(cld.getTime()) + " --" + Sunday_date);
    }

    public static String getCurrentDateString() {
        SimpleDateFormat sdf_day = new SimpleDateFormat("yyyyMMdd");
        Calendar calendar = Calendar.getInstance();
        String today_date = sdf_day.format(calendar.getTime());
        return today_date;
    }
}

