package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import java.util.HashMap;
import java.util.Map;

/**
 * @author NHX
 * @Function C端获取学生信息列表
 * @Date 2020/11/19 15:01
 */
public class TestGetStudentInstLinkageList_C extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_customerLive) // API 所属模块
                .setApiName("API_getStudentInstLinkageList") // API 名称
                .setLoginUser("NHX_c")         // http 接口，测试账号
                .setTerminal(Terminal.C);             // 所属端位（B端，C端，M端等, 必传）

        dal.setCase_owner("NHX")
                .setCase_name("C端获取学生信息列表：" + Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);

        super.beforeTest();
    }

    @Test(description = "C端获取学生信息列表")
    public void testLoadStudentListAPI(){

        Map<String,Object> bodyMap = new HashMap<>();

        JSONObject jsonBody = new JSONObject(bodyMap);
        String data = jsonBody.toJSONString();

        System.out.println("请求参数==========="+data);
        // "exception": "java.lang.IllegalArgumentException: userId不能为空； headers加userId
        headers.put("userId","1145612151844098049");

        xmAppApi.doRequest(RequestType.JSON, params, data, headers);
        JSONObject jsonResponseBody = xmAppApi.getBodyInJSON();
        Assert.assertEquals(jsonResponseBody.getString("success"), "true", "操作成功!");


    }

}
