/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomai.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.client.OkHttpClient;
import com.xiaomai.client.RestfulClient;
import com.xiaomai.client.SSLRestfulClient;
import com.xiaomai.client.UtDal;
import com.xiaomai.client.XMAppApi;
import com.xiaomai.utils.CommUtil;
import com.xiaomai.utils.CommonLogin;
import com.xiaomai.utils.CommonLoginInfo;
import com.xiaomai.utils.CommonRequestParameters;
import com.xiaomai.utils.JsonAndFile;
import com.xiaomai.utils.SpringContextUtil;
import com.xiaomai.utils.XMBaseTest;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.util.StringUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestRunner;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.internal.InvokedMethod;

public class BaseTest
extends AbstractTestNGSpringContextTests {
    private static final Log logger = LogFactory.getLog(XMBaseTest.class);
    public static RestfulClient httpclient = null;
    public static SSLRestfulClient sslhttpclient = null;
    public static OkHttpClient okHttpClient = null;
    public static HashMap<String, String> headers;
    public static IdentityHashMap<String, String> params;
    public static Map restParams;
    public static Map miniAppRestParams;
    public static Map restParamsAnother;
    private static String host;
    public static String url;
    private Properties prop = null;
    public static UtDal dal;
    public static volatile XMAppApi xmAppApi;
    private static CommonRequestParameters loginInfo;
    public static HashMap<String, String> dataheadrs;
    public static IdentityHashMap<String, String> dataparams;
    public static XMAppApi dataApi;
    private static final Logger LOGGER;

    @BeforeClass
    public static void beforeClass() {
        httpclient = new RestfulClient();
        sslhttpclient = new SSLRestfulClient();
        okHttpClient = new OkHttpClient();
        xmAppApi = new XMAppApi();
        dal = new UtDal();
    }

    @BeforeMethod
    public void beforeTest() {
        params = new IdentityHashMap();
        restParams = new HashMap();
        miniAppRestParams = new HashMap();
        restParamsAnother = new HashMap();
        dataparams = new IdentityHashMap();
        dataApi = new XMAppApi();
        this.clearApiData(xmAppApi);
        headers = new HashMap();
        this.dataPreparation(xmAppApi, headers);
    }

    private void clearApiData(XMAppApi api) {
        api.setApi_request_params(new IdentityHashMap<String, String>());
        api.setApi_request_data(null);
        api.setApi_request_headers(new HashMap<String, String>());
        api.setApi_response(null);
        api.setApi_traceId(null);
    }

    public void beforeDataRequest(DataUserInfo ... userInfos) {
        this.clearApiData(dataApi);
        dataheadrs = new HashMap();
        dataApi.setLoginUser(xmAppApi.getLoginUser()).setTerminal(xmAppApi.getTerminal());
        if (userInfos.length > 0) {
            DataUserInfo info = userInfos[0];
            Assert.assertNotNull((Object)info, (String)"userInfos \u4e3a\u7a7a\uff01\uff01\uff01");
            if (!StringUtils.isEmpty((Object)info.getLoginUser())) {
                dataApi.setLoginUser(info.getLoginUser());
            }
            if (!StringUtils.isEmpty((Object)info.getTerminal())) {
                dataApi.setTerminal(info.getTerminal());
            }
        }
        this.dataPreparation(dataApi, dataheadrs);
    }

    private void dataPreparation(XMAppApi executionApi, HashMap<String, String> executionHeaders) {
        Assert.assertNotNull((Object)executionApi.getApiModule(), (String)"\u5fc5\u8981\u7684api\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        this.prop = CommUtil.getconfig();
        JsonAndFile fileHandle = new JsonAndFile();
        String apiModule = this.prop.getProperty(executionApi.getApiModule());
        String fileParam = JsonAndFile.readTxtFile(System.getProperty("user.dir") + apiModule);
        Assert.assertNotNull((Object)fileParam, (String)"\u5fc5\u8981\u7684API\u6a21\u5757\u4fe1\u606f\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5api\u6a21\u5757\u6587\u4ef6\u8def\u5f84\uff01");
        JSONObject api = (JSONObject)JSON.parseObject((String)fileParam).get((Object)executionApi.getApiName());
        Assert.assertNotNull((Object)api, (String)"\u5fc5\u8981\u7684API\u63a5\u53e3\u4fe1\u606f\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5apiName\u4fe1\u606f\uff01");
        executionApi.setApiDesc(api.getString("apiName"));
        if (api.containsKey((Object)"requestParamter")) {
            executionApi.setRequestParamterTemplate(api.getString("requestParamter"));
        }
        String env = "prod";
        if (xmAppApi.getTerminal().equals("M")) {
            env = "rc";
        }
        host = this.prop.getProperty(env);
        CommonLoginInfo loginInfoMap = (CommonLoginInfo)SpringContextUtil.getBean("commonLoginInfoMap");
        loginInfo = loginInfoMap.get(executionApi.getLoginUser());
        if (StringUtils.isEmpty((Object)loginInfo.getToken())) {
            CommonLogin common_login = new CommonLogin();
            common_login.login(env, executionApi.getLoginUser(), executionApi.getTerminal());
            loginInfo = loginInfoMap.get(executionApi.getLoginUser());
        }
        url = host + api.getString("apiPath") + loginInfo.getCommonParam(executionApi.getTerminal());
        executionApi.setUrl(url);
        System.out.println("\u4e1a\u52a1\u8bf7\u6c42URL==>>" + url);
        if ("B".equals(executionApi.getTerminal())) {
            executionHeaders.put("instid", loginInfo.getInstId());
            executionHeaders.put("bizAccountId", loginInfo.getAid());
            executionHeaders.put("xmversion", "5.0");
            executionHeaders.put("vn", "5.4.0");
        } else if ("M".equals(executionApi.getTerminal())) {
            executionHeaders.put("usertype", loginInfo.getUserType());
            executionHeaders.put("deptpath", loginInfo.getDeptpath());
        }
        executionHeaders.put("xm_request_source", "test");
        executionHeaders.put("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36");
        executionHeaders.put("Accept", "*/*");
        executionHeaders.put("Connection", "Keep-Alive");
        if (api.containsKey((Object)"apiContentType") || StringUtils.isEmpty((Object)api.getString("apiContentType"))) {
            executionHeaders.put("Content-type", "application/json;charset=utf-8");
        } else {
            executionHeaders.put("Content-type", api.getString("apiContentType"));
        }
    }

    private String getTestName(ITestResult test) {
        ITestNGMethod testMethod = test.getMethod();
        ITestContext context = test.getTestContext();
        TestRunner run = (TestRunner)context;
        String parameters = "";
        Class<?> clazz = run.getClass();
        try {
            Field field = clazz.getDeclaredField("m_invokedMethods");
            field.setAccessible(true);
            List list = (List)field.get(run);
            for (InvokedMethod in : list) {
                Object[] ab;
                if (!testMethod.getMethodName().equals(in.getTestMethod().getMethodName())) continue;
                Class<?> clazz_in = in.getClass();
                Field field_in = clazz_in.getDeclaredField("m_parameters");
                field_in.setAccessible(true);
                for (Object o : ab = (Object[])field_in.get(in)) {
                    parameters = parameters + o.toString() + ",";
                }
            }
            if (parameters.length() > 0) {
                parameters = parameters.substring(0, parameters.length() - 1);
                parameters = "[" + parameters + "]";
            }
            System.out.println("testName: " + testMethod.getMethodName() + parameters);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return testMethod.getMethodName() + parameters;
    }

    @AfterMethod
    public void afterMethod(ITestResult result) {
        result.setAttribute("ApiDesc", (Object)xmAppApi.getApiDesc());
        result.setAttribute("Url", (Object)xmAppApi.getUrl());
        result.setAttribute("RequestParams", (Object)xmAppApi.getApi_request_params().toString());
        result.setAttribute("RequestData", (Object)xmAppApi.getApi_request_data());
        result.setAttribute("CaseOwner", (Object)dal.getCase_owner());
        result.setAttribute("TraceId", (Object)xmAppApi.getApi_traceId());
        if (xmAppApi.getApi_startTime() != null) {
            result.setAttribute("StartTime", (Object)new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(xmAppApi.getApi_startTime()));
        }
        Long expendTime = xmAppApi.getApi_requestTime();
        result.setAttribute("ExpendTime", (Object)(expendTime + "ms"));
        result.setAttribute("Response", (Object)xmAppApi.getApi_response());
        if (expendTime != null) {
            if (expendTime >= 500L && expendTime <= 1000L) {
                LOGGER.warn(xmAppApi.getApiDesc() + "\u63a5\u53e3\u8bf7\u6c42\u65f6\u95f4\u8d85\u8fc7500\u6beb\u79d2 = " + expendTime.toString());
            } else if (expendTime > 1000L) {
                LOGGER.error(xmAppApi.getApiDesc() + " \u63a5\u53e3\u8bf7\u6c42\u65f6\u95f4\u8d85\u8fc71\u79d2 = " + expendTime.toString());
            }
        }
    }

    @AfterClass
    public static void afterClass() {
        httpclient.shutDownConnection();
        sslhttpclient.shutDownConnection();
    }

    static {
        host = null;
        url = null;
        LOGGER = LoggerFactory.getLogger(BaseTest.class);
    }
}

