package com.live.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

import java.util.ArrayList;

/**
 * 创建直播课，返回课程id
 * by 张雨朦
 */

public class GetLiveCourseId extends XMBaseTest {

    public String createCourse(){
        dataApi.setApiModule(ApiModele.CloudClass_B)
                .setApiName("API_createBigLiveCourse")
                .setTerminal(Terminal.B);
        super.beforeDataRequest();

        JSONObject jsonObject = new JSONObject();
        TimeSetting startTime = new TimeSetting();
        jsonObject.put("startTime", startTime.startTime());
        TimeSetting endTime = new TimeSetting();
        jsonObject.put("endTime", endTime.endTime());
        jsonObject.put("teacherId","1323235986786807809");
        jsonObject.put("liveType", "LARGE_CLASS_LIVE");
        jsonObject.put("adminIds", new ArrayList<>());
        jsonObject.put("courseName", "自动化创建直播课");
        jsonObject.put("studentIds", new ArrayList<>());
        jsonObject.put("consumeStudentIds", new JSONArray());
        jsonObject.put("liveCourseMediaRequests", new JSONArray());
        jsonObject.put("needRecord", "YES");
        jsonObject.put("applyMode", "ANYONE");

        dataApi.doRequest(com.live.enums.RequestType.JSON,dataparams,jsonObject.toJSONString(),dataheadrs).assetsSuccess(true);

        JSONObject responseRes = dataApi.getBodyInJSON();
        String liveCourseID = responseRes.getString("result");
        return liveCourseID;

    }

}
