package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/03
 */

public  class TestGetCourseDetail extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getCourseDetail") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 大班互动直播课-课程详情
     */
    @Test(description = "已添加学员的大班互动课，查看详情")
    public void testGetCourseDetail() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.getInteractionClassLiveList1("大班互动");

        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId  ="+liveCourseId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody.getJSONObject("result").getString("liveCourseId") );

        Assert.assertEquals(liveCourseId,jsonBody.getJSONObject("result").getString("liveCourseId"));
        Assert.assertEquals(2,jsonBody.getJSONObject("result").getJSONArray("liveStudentBaseVO").size());
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

    /**
     * 大班互动直播课-课程详情
     */
    @Test(description = "普通的大班互动课，查看详情")
    public void testGetCourseDetail1() throws InterruptedException {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.createLargeInteractionClassLive();

        String liveCourseId = getLargeCourseData.getString("result");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody.getJSONObject("result").getString("liveCourseId") );

        Assert.assertEquals(liveCourseId,jsonBody.getJSONObject("result").getString("liveCourseId"));
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

}
