package com.live.cases.musicPlay;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetOnlyOneClassLiveListData;
import com.live.xmutils.GetOnlyOneCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangying
 * @date 2021/2/7 4:55 下午
 */
public class TestAddCourseStu extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_addCourseStu") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("zhangying");
        super.beforeTest();
    }

    /**
     * 测试乐器陪练课-添加学员"不扣课时学员（自动化测试）"
     */

    @Test
    public void testAddCourseStu() throws InterruptedException {
        GetOnlyOneCourseData onlyOneCourseData = new GetOnlyOneCourseData();
        JSONObject onlyOneClassCourse = onlyOneCourseData.creatOnlyOneCourse();

        String liveCourseId = onlyOneClassCourse.getString("result");
        System.out.println("liveCourseId  ="+liveCourseId);

        String studentId = "1358297612940660738";
        List studentIds = new ArrayList();
        studentIds.add(studentId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("studentIds",studentIds);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);

        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        JSONObject onlyOneCourseList = onlyOneCourseData.getOnlyOneCourseList();
        String studentId1 = onlyOneCourseList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONArray("liveStudentBaseVO").getJSONObject(0).getString("studentId");

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals(studentId, studentId1);

    }

    /**
     * 测试乐器陪练课-添加学员"扣课时学员（自动化测试）"
     */

    @Test
    public void testAddCourseStu1() throws InterruptedException {
        GetOnlyOneCourseData onlyOneCourseData = new GetOnlyOneCourseData();
        JSONObject onlyOneClassCourse = onlyOneCourseData.creatOnlyOneCourse();

        String liveCourseId = onlyOneClassCourse.getString("result");
        System.out.println("liveCourseId  ="+liveCourseId);

        String studentId = "1358346398485405697";
        JSONObject jsondata = new JSONObject();
        jsondata.put("name","扣课时学员（自动化测试）");
        jsondata.put("phone","12300000003");
        jsondata.put("studentId",studentId);
        jsondata.put("classHourId","1235120275888328705");
        jsondata.put("consumeHourNum","100");

        List studentIds = new ArrayList();
        studentIds.add(jsondata);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("consumeStudentIds",studentIds);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);

        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        JSONObject onlyOneCourseList = onlyOneCourseData.getOnlyOneCourseList();
        String studentId1 = onlyOneCourseList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONArray("liveStudentBaseVO").getJSONObject(0).getString("studentId");

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals(studentId, studentId1);

    }
}
