package com.live.cases.fileManage.commonFolder;

import com.alibaba.fastjson.JSONObject;
import com.live.xmutils.GetFolderData;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description 删除公共文件列表的文件
 * @author zhangyumeng
 */

public class TestDelCommonFolder extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModele.CloudClass_File )
                .setApiName("API_delCommomFolder")
                .setLoginUser("zhangy-b")  //张莹的机构里文件夹数据比较多，所以这里用她的测删除文件夹
                .setTerminal(Terminal.B);
        super.beforeTest();
    }

   @Test(description = "删除单个文件")
    public void testDelCommonFolderList() throws InterruptedException {
        GetFolderData testCommonFolderList = new GetFolderData();
       JSONObject folderList = testCommonFolderList.getCommonFolderList();
       String id = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        System.out.println("获取id" + id);

        JSONObject jsonObject = new JSONObject();
        List StringList = new ArrayList();
        StringList.add(id);
        jsonObject.put("ids", StringList);
        jsonObject.put("instId","1300628703858597889");
        System.out.println("请求" + jsonObject);

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject responseRes = xmAppApi.getBodyInJSON();

       JSONObject folderList1 = testCommonFolderList.getCommonFolderList();
       String id1 = folderList1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
       System.out.println("id1  == "+id1);

       Assert.assertEquals("true", responseRes.getString("success"));
       Assert.assertEquals("200", responseRes.getString("code"));
       Assert.assertNotEquals(id1, id);
    }

    @Test(description = "批量删除多个文件")
    public void testDelCommonFolderList1() throws InterruptedException {
        GetFolderData testCommonFolderList = new GetFolderData();
        JSONObject folderList = testCommonFolderList.getCommonFolderList();
        System.out.println("folderList =="+folderList);
        String folderId = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        String folderId1 = folderList.getJSONObject("result").getJSONArray("records").getJSONObject(1).getString("id");

        JSONObject jsonObject = new JSONObject();
        List StringList = new ArrayList();
        StringList.add(folderId);
        StringList.add(folderId1);
        jsonObject.put("ids", StringList);
        jsonObject.put("instId","1300628703858597889");
        System.out.println("请求" + jsonObject);

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject responseRes = xmAppApi.getBodyInJSON();

        JSONObject folderList1 = testCommonFolderList.getCommonFolderList();
        String id = folderList1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        String id1 = folderList1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");
        System.out.println("id1  == "+id1);

        Assert.assertEquals("true", responseRes.getString("success"));
        Assert.assertEquals("200", responseRes.getString("code"));
        Assert.assertNotEquals(folderId, id);
        Assert.assertNotEquals(folderId1, id1);
    }

}
