package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author zhangying
 * @date 2021/3/12 18:08
 */
public class TestCreateBigInteractionCourse extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_createBigLiveCourse") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    @Test(description = "创建普通大班互动课，不添加学员")
    public void testCreateBigInteractionCourse() throws InterruptedException {

        JSONObject largeInteractionClassLive = new JSONObject();
        largeInteractionClassLive.put("courseName", RandomStringUtil.randomNumber(14, "course_"));
        largeInteractionClassLive.put("teacherId","1235115979473997826");
        largeInteractionClassLive.put("startTime",System.currentTimeMillis() + 60 * 1000);
        largeInteractionClassLive.put("endTime",System.currentTimeMillis() + 30 * 60 * 1000);
        largeInteractionClassLive.put("needRecord","NO");
        largeInteractionClassLive.put("liveType","LARGE_CLASS_INTERACTION");
        largeInteractionClassLive.put("consumeHourNum",1);
        largeInteractionClassLive.put("consumeClassTime","1");
        largeInteractionClassLive.put("podium","12");

        xmAppApi.doRequest(RequestType.JSON, params, largeInteractionClassLive.toJSONString(), headers);
        TimeUnit.SECONDS.sleep(3);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        String courseId =jsonBody.getString("result");

        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getCourseData = getLiveCourseData.getInteractionClassLiveList();
        System.out.println("getCourseData"+getCourseData);

        String courseId1 = getCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals(courseId, courseId1);

    }

    @Test(description = "创建大班互动课，同时添加扣课时学员和不扣课时学员")
    public void testCreateBigInteractionCourse1() throws InterruptedException {

        //组装扣课时学员数据
        String studentId = "1358346398485405697";   //扣课时学员
        JSONObject jsondata = new JSONObject();
        jsondata.put("name","扣课时学员（自动化测试）");
        jsondata.put("phone","12300000003");
        jsondata.put("studentId",studentId);
        jsondata.put("classHourId","1235120275888328705");
        jsondata.put("consumeHourNum","100");

        //组装不扣课时学员数据
        List consumeStudentIds = new ArrayList();
        consumeStudentIds.add(jsondata);

        String studentId1 = "1358297612940660738";  //不扣课时学员
        List studentIds = new ArrayList();
        studentIds.add(studentId1);

        JSONObject largeInteractionClassLive = new JSONObject();
        largeInteractionClassLive.put("courseName", RandomStringUtil.randomNumber(14, "大班互动_"));
        largeInteractionClassLive.put("teacherId","1235115979473997826");
        largeInteractionClassLive.put("startTime",System.currentTimeMillis() + 60 * 1000);
        largeInteractionClassLive.put("endTime",System.currentTimeMillis() + 30 * 60 * 1000);
        largeInteractionClassLive.put("needRecord","YES");
        largeInteractionClassLive.put("liveType","LARGE_CLASS_INTERACTION");
        largeInteractionClassLive.put("consumeHourNum",1);
        largeInteractionClassLive.put("consumeClassTime","1");
        largeInteractionClassLive.put("podium","12");
        largeInteractionClassLive.put("consumeStudentIds",consumeStudentIds);
        largeInteractionClassLive.put("studentIds",studentIds);

        xmAppApi.doRequest(RequestType.JSON, params, largeInteractionClassLive.toJSONString(), headers);
        TimeUnit.SECONDS.sleep(3);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        String courseId =jsonBody.getString("result");

        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getCourseData = getLiveCourseData.getInteractionClassLiveList();
        System.out.println("getCourseData"+getCourseData);

        String courseId1 = getCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals(courseId, courseId1);

    }

}
