package com.live.cases.largeClassLive;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetLiveCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @author zhangying
 * @date 2021/2/24 3:53 下午
 */
public class TestUpdateCourse extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_updateCourse") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 测试大班直播课，编辑课程-编辑名称
     */
    @Test(description = "测试大班直播课，编辑课程-编辑名称")
    public void testUpdateCourse() throws InterruptedException {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.createLargeClassLive();
        String liveCourseId = getLargeCourseData.getString("result");
        System.out.println("liveCourseId   =="+liveCourseId);

        JSONArray jsonArray = new JSONArray();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("adminIds",jsonArray);
        jsonObject.put("applyMode","ANYONE");  //分享设置-任何学员
        jsonObject.put("autoSendReport","OFF_AUTO");
        jsonObject.put("consumeClassTime",1);
        jsonObject.put("consumeHourNum",1);
        jsonObject.put("consumeStudentIds",jsonArray);
        jsonObject.put("courseName",RandomStringUtil.randomNumber(14, "测试编辑_course_"));
        jsonObject.put("TestUpdateCourse","https://image.xiaomaiketang.com/xm/YNfi45JwFA.png");
        jsonObject.put("endTime",System.currentTimeMillis() + 30 * 60 * 1000);
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("liveCourseMediaRequests",jsonArray);
        jsonObject.put("liveType","LARGE_CLASS_LIVE");
        jsonObject.put("needRecord","YES");
        jsonObject.put("startTime",System.currentTimeMillis() + 60 * 1000);
        jsonObject.put("studentIds",jsonArray);
        jsonObject.put("teacherId",xmAppApi.getLoginInfo().getTid());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        JSONObject getLargeCourseData1 = getLiveCourseData.getLargeClassLiveList();
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        Assert.assertEquals(liveCourseId1, liveCourseId);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
    }

    /**
     * 测试大班直播课，编辑课程-修改分享设置
     */
    @Test(description = "测试大班直播课，编辑课程-修改分享设置")
    public void testUpdateCourse1() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.getLargeClassLiveList();
        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId   =="+liveCourseId);

        JSONArray jsonArray = new JSONArray();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("adminIds",jsonArray);
        jsonObject.put("applyMode","ONLY_READ");  //分享设置-仅在读
        jsonObject.put("autoSendReport","OFF_AUTO");
        jsonObject.put("consumeClassTime",1);
        jsonObject.put("consumeHourNum",1);
        jsonObject.put("consumeStudentIds",jsonArray);
        jsonObject.put("courseName",RandomStringUtil.randomNumber(14, "测试编辑_course_"));
        jsonObject.put("TestUpdateCourse","https://image.xiaomaiketang.com/xm/YNfi45JwFA.png");
        jsonObject.put("endTime",System.currentTimeMillis() + 30 * 60 * 1000);
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("liveCourseMediaRequests",jsonArray);
        jsonObject.put("liveType","LARGE_CLASS_LIVE");
        jsonObject.put("needRecord","YES");
        jsonObject.put("startTime",System.currentTimeMillis() + 60 * 1000);
        jsonObject.put("studentIds",jsonArray);
        jsonObject.put("teacherId",xmAppApi.getLoginInfo().getTid());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        JSONObject getLargeCourseData1 = getLiveCourseData.getLargeClassLiveList();
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        Assert.assertEquals(liveCourseId1, liveCourseId);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
    }


    /**
     * 测试大班直播课，编辑课程-添加扣课时学员
     */
    @Test(description = "测试大班直播课，编辑课程-添加扣课时学员")
    public void testUpdateCourse2() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.getLargeClassLiveList();
        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId   =="+liveCourseId);

        JSONArray jsonArray = new JSONArray();

        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("name","扣课时学员（自动化测试）");
        jsonObject1.put("phone","12300000003");
        jsonObject1.put("studentId","1358346398485405697");
        jsonObject1.put("consumeHourNum","100");
        jsonObject1.put("classHourId","1235120275888328705");

        JSONArray jsonArray1 = new JSONArray();
        jsonArray1.add(jsonObject1);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("adminIds",jsonArray);
        jsonObject.put("applyMode","ONLY_READ");  //分享设置-仅在读
        jsonObject.put("autoSendReport","OFF_AUTO");
        jsonObject.put("consumeClassTime",1);
        jsonObject.put("consumeHourNum",1);
        jsonObject.put("consumeStudentIds",jsonArray1);
        jsonObject.put("courseName",RandomStringUtil.randomNumber(14, "测试编辑_course_"));
        jsonObject.put("TestUpdateCourse","https://image.xiaomaiketang.com/xm/YNfi45JwFA.png");
        jsonObject.put("endTime",System.currentTimeMillis() + 30 * 60 * 1000);
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("liveCourseMediaRequests",jsonArray);
        jsonObject.put("liveType","LARGE_CLASS_LIVE");
        jsonObject.put("needRecord","YES");
        jsonObject.put("startTime",System.currentTimeMillis() + 60 * 1000);
        jsonObject.put("studentIds",jsonArray);
        jsonObject.put("teacherId",xmAppApi.getLoginInfo().getTid());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        JSONObject getLargeCourseData1 = getLiveCourseData.getLargeClassLiveList();
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        Assert.assertEquals(liveCourseId1, liveCourseId);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
    }


    /**
     * 测试大班直播课，编辑课程-添加封面图
     */
    @Test(description = "测试大班直播课，编辑课程-添加封面图")
    public void testUpdateCourse3() {
        GetLiveCourseData getLiveCourseData = new GetLiveCourseData();
        JSONObject getLargeCourseData = getLiveCourseData.getLargeClassLiveList();
        String liveCourseId = getLargeCourseData.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId   =="+liveCourseId);

        JSONArray jsonArray = new JSONArray();

        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put("studentId","1235120275888328705");
        jsonObject1.put("classHourId","1358346398485405697");

        JSONArray jsonArray1 = new JSONArray();
        jsonArray1.add(jsonObject1);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("adminIds",jsonArray);
        jsonObject.put("applyMode","ONLY_READ");  //分享设置-仅在读
        jsonObject.put("autoSendReport","OFF_AUTO");
        jsonObject.put("consumeClassTime",1);
        jsonObject.put("consumeHourNum",1);
        jsonObject.put("consumeStudentIds",jsonArray1);
        jsonObject.put("courseName",RandomStringUtil.randomNumber(14, "测试编辑_course_"));
        jsonObject.put("TestUpdateCourse","https://image.xiaomaiketang.com/xm/YNfi45JwFA.png");
        jsonObject.put("endTime",System.currentTimeMillis() + 30 * 60 * 1000);
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("liveCourseMediaRequests",jsonArray);
        jsonObject.put("liveType","LARGE_CLASS_LIVE");
        jsonObject.put("needRecord","YES");
        jsonObject.put("startTime",System.currentTimeMillis() + 60 * 1000);
        jsonObject.put("studentIds",jsonArray);
        jsonObject.put("teacherId",xmAppApi.getLoginInfo().getTid());
        jsonObject.put("coverUrl","blob:https://b.xiaomai5.com/34279850-7b4a-4695-b19c-0da735864190");  //编辑封面图片

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        JSONObject getLargeCourseData1 = getLiveCourseData.getLargeClassLiveList();
        String liveCourseId1 = getLargeCourseData1.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("liveCourseId");
        System.out.println("liveCourseId1   =="+liveCourseId1);

        Assert.assertEquals(liveCourseId1, liveCourseId);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
    }
}
