package com.live.cases.musicPlay;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/04
 */

public  class TestUpdateStudentVisitCheckedData extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_updateStudentVisitCheckedData") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 乐器陪练-学员上课数据，学员课时清零之后，修改扣课时数为0
     */
    @Test
    public void testUpdateStudentVisitCheckedData() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("consumeHourClassId","1237292779809337345");
        jsonObject.put("consumeHourNum","0");
        jsonObject.put("consumeUserId","1235115979394306049");
        jsonObject.put("instId","1235115978015883266");
        jsonObject.put("liveStudentId","1357211987609444353");
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

    /**
     * 乐器陪练-学员上课数据，学员课时清零之后，修改扣课时数为1
     */
    @Test
    public void testUpdateStudentVisitCheckedData1() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("consumeHourClassId","1237292779809337345");
        jsonObject.put("consumeHourNum","1");
        jsonObject.put("consumeUserId","1235115979394306049");
        jsonObject.put("instId","1235115978015883266");
        jsonObject.put("liveStudentId","1357211987609444353");
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        Assert.assertEquals("不能超过剩余课时数", jsonBody.getString("message"));

    }

}
