package com.live.cases.seriesCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetSeriesCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/24 2:55 下午
 */
public class TestMoveSeries extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_moveSeries") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    @Test
    public void testMoveSeriesUP(){

        GetSeriesCourseData getSeriesCourseData = new GetSeriesCourseData();
        //获取当前系列课列表第一页的第2个课次
        String seriesId = getSeriesCourseData.getSeriesPage().getJSONObject("result").getJSONArray("records").getJSONObject(1).getString("id");

        Map bodyMap = new HashMap();
        bodyMap.put("seriesId",seriesId);
        bodyMap.put("move","UP");

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        String seriesIdUp = getSeriesCourseData.getSeriesPage().getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        Assert.assertEquals(seriesId,seriesIdUp);


    }


    @Test
    public void testMoveSeriesDown(){

        GetSeriesCourseData getSeriesCourseData = new GetSeriesCourseData();
        //获取当前系列课列表第一页的第1个课次
        String seriesId = getSeriesCourseData.getSeriesPage().getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        Map bodyMap = new HashMap();
        bodyMap.put("seriesId",seriesId);
        bodyMap.put("move","DOWN");

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        String seriesIdDown = getSeriesCourseData.getSeriesPage().getJSONObject("result").getJSONArray("records").getJSONObject(1).getString("id");

        Assert.assertEquals(seriesId,seriesIdDown);


    }

}
