package com.live.cases.myClassAPP;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

import static io.restassured.RestAssured.given;
import static org.hamcrest.Matchers.equalTo;

/**
 * @author NHX--->zhangying
 * @Function C端课表管理-课次详情 按关系Id获取关系
 * @Date 2020/11/19 15:01
 */
public class TestGetRelationByRelationId_C extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_customerLive) // API 所属模块
                .setApiName("API_getRelationByRelationId") // API 名称
                .setLoginUser("zhangy-APPC")         // http 接口，测试账号
                .setTerminal(Terminal.APP_C);             // 所属端位（B端，C端，M端等, 必传）

        dal.setCase_owner("NHX")
                .setCase_name("C端课表管理-课次详情 按关系Id获取关系：" + Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);

        super.beforeTest();
    }

    @Test(description = "C端课表管理-课次详情 按关系Id获取关系")
    public void testGetRelationByRelationId(){


        Map<String,Object> bodyMap = new HashMap<>();
        bodyMap.put("relationId","1145627043559436291");
        bodyMap.put("relationType","SCHEDULE");

        JSONObject jsonBody = new JSONObject(bodyMap);
        String data = jsonBody.toJSONString();

        System.out.println("请求参数==========="+data);
        xmAppApi.doRequest(RequestType.JSON, params, data, headers);
        JSONObject jsonResponseBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonResponseBody   =="+jsonResponseBody);
        Assert.assertEquals(jsonResponseBody.getString("success"), "true");


    }

}
