/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomai.client;

import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.ResourceCDN;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.TestAttribute;
import com.aventstack.extentreports.reporter.ExtentHtmlReporter;
import com.aventstack.extentreports.reporter.configuration.ChartLocation;
import com.aventstack.extentreports.reporter.configuration.Theme;
import java.io.File;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.xml.XmlSuite;

public class ExtentTestNGIReporterListener
implements IReporter {
    private static final String OUTPUT_FOLDER = "test-output/";
    private static final String FILE_NAME = "report.html";
    private ExtentReports extent;

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        this.init();
        boolean createSuiteNode = false;
        if (suites.size() > 1) {
            createSuiteNode = true;
        }
        for (ISuite suite : suites) {
            Map result = suite.getResults();
            if (result.size() == 0) continue;
            int suiteFailSize = 0;
            int suitePassSize = 0;
            int suiteSkipSize = 0;
            ExtentTest suiteTest = null;
            if (createSuiteNode) {
                suiteTest = this.extent.createTest(suite.getName()).assignCategory(new String[]{suite.getName()});
            }
            boolean createSuiteResultNode = false;
            if (result.size() > 1) {
                createSuiteResultNode = true;
            }
            for (ISuiteResult r : result.values()) {
                ITestContext context = r.getTestContext();
                ExtentTest resultNode = createSuiteResultNode ? (null == suiteTest ? this.extent.createTest(r.getTestContext().getName()) : suiteTest.createNode(r.getTestContext().getName())) : suiteTest;
                if (resultNode != null) {
                    resultNode.getModel().setName(suite.getName() + " : " + r.getTestContext().getName());
                    if (resultNode.getModel().hasCategory()) {
                        resultNode.assignCategory(new String[]{r.getTestContext().getName()});
                    } else {
                        resultNode.assignCategory(new String[]{suite.getName(), r.getTestContext().getName()});
                    }
                    resultNode.getModel().setStartTime(r.getTestContext().getStartDate());
                    resultNode.getModel().setEndTime(r.getTestContext().getEndDate());
                    int passSize = r.getTestContext().getPassedTests().size();
                    int failSize = r.getTestContext().getFailedTests().size();
                    int skipSize = r.getTestContext().getSkippedTests().size();
                    suitePassSize += passSize;
                    suiteFailSize += failSize;
                    suiteSkipSize += skipSize;
                    if (failSize > 0) {
                        resultNode.getModel().setStatus(Status.FAIL);
                    }
                    resultNode.getModel().setDescription(String.format("Pass: %s ; Fail: %s ; Skip: %s ;", passSize, failSize, skipSize));
                }
                this.buildTestNodes(resultNode, context.getFailedTests(), Status.FAIL);
                this.buildTestNodes(resultNode, context.getSkippedTests(), Status.SKIP);
                this.buildTestNodes(resultNode, context.getPassedTests(), Status.PASS);
            }
            if (suiteTest == null) continue;
            suiteTest.getModel().setDescription(String.format("Pass: %s ; Fail: %s ; Skip: %s ;", suitePassSize, suiteFailSize, suiteSkipSize));
            if (suiteFailSize <= 0) continue;
            suiteTest.getModel().setStatus(Status.FAIL);
        }
        this.extent.flush();
    }

    private void init() {
        File reportDir = new File(OUTPUT_FOLDER);
        if (!reportDir.exists() && !reportDir.isDirectory()) {
            reportDir.mkdir();
        }
        ExtentHtmlReporter htmlReporter = new ExtentHtmlReporter("test-output/report.html");
        htmlReporter.config().setResourceCDN(ResourceCDN.EXTENTREPORTS);
        htmlReporter.config().setResourceCDN(ResourceCDN.EXTENTREPORTS);
        htmlReporter.config().setDocumentTitle("\u81ea\u52a8\u5316\u6d4b\u8bd5\u62a5\u544a");
        htmlReporter.config().setReportName("\u5c0f\u9ea6\u81ea\u52a8\u5316\u6d4b\u8bd5\u62a5\u544a");
        htmlReporter.config().setChartVisibilityOnOpen(true);
        htmlReporter.config().setTestViewChartLocation(ChartLocation.TOP);
        htmlReporter.config().setTheme(Theme.STANDARD);
        htmlReporter.config().setCSS(".node.level-1  ul{ display:none;} .node.level-1.active ul{display:block;}");
        this.extent = new ExtentReports();
        this.extent.attachReporter(new ExtentReporter[]{htmlReporter});
        this.extent.setReportUsesManualConfiguration(true);
    }

    private void buildTestNodes(ExtentTest extenttest, IResultMap tests, Status status) {
        String[] categories = new String[]{};
        if (extenttest != null) {
            List categoryList = extenttest.getModel().getCategoryContext().getAll();
            categories = new String[categoryList.size()];
            for (int index = 0; index < categoryList.size(); ++index) {
                categories[index] = ((TestAttribute)categoryList.get(index)).getName();
            }
        }
        if (tests.size() > 0) {
            TreeSet<ITestResult> treeSet = new TreeSet<ITestResult>(new Comparator<ITestResult>(){

                @Override
                public int compare(ITestResult o1, ITestResult o2) {
                    return o1.getStartMillis() < o2.getStartMillis() ? -1 : 1;
                }
            });
            treeSet.addAll(tests.getAllResults());
            for (ITestResult result : treeSet) {
                String[] attrNames;
                String name = "";
                String description = result.getMethod().getDescription();
                if (description != null) {
                    name = description + "_" + result.getMethod().getMethodName();
                } else {
                    String ApiName = "\u6d4b\u8bd5\u8bf7\u6c42";
                    if (null != result.getAttribute("ApiName")) {
                        ApiName = ApiName + result.getAttribute("ApiName").toString();
                    }
                    name = ApiName + "_" + result.getMethod().getMethodName();
                }
                String parametersStr = "";
                for (Object param : result.getParameters()) {
                    parametersStr = parametersStr + param + ",";
                }
                if (parametersStr.length() > 0) {
                    parametersStr = parametersStr.substring(0, parametersStr.length() - 1);
                    parametersStr = "[" + parametersStr + "]";
                }
                name = name + parametersStr;
                ExtentTest test = extenttest == null ? this.extent.createTest(name) : extenttest.createNode(name).assignCategory(categories);
                for (String group : result.getMethod().getGroups()) {
                    test.assignCategory(new String[]{group});
                }
                List outputList = Reporter.getOutput((ITestResult)result);
                for (String output : outputList) {
                    test.debug(output);
                }
                for (String attrName : attrNames = new String[]{"Url", "RequestParams", "RequestData", "CaseOwner", "TraceId", "StartTime", "ExpendTime", "Response"}) {
                    String infoName = "<span class=\"label start-time\">" + attrName + "</span><br>";
                    test.debug(infoName + result.getAttribute(attrName));
                }
                if (result.getThrowable() != null) {
                    test.log(status, result.getThrowable());
                } else {
                    test.log(status, "Test " + status.toString().toLowerCase() + "ed");
                }
                test.getModel().setStartTime(this.getTime(result.getStartMillis()));
                test.getModel().setEndTime(this.getTime(result.getEndMillis()));
            }
        }
    }

    private Date getTime(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar.getTime();
    }
}

