package com.live.cases.fileManage;

import com.alibaba.fastjson.JSONObject;
import com.live.xmutils.CloudClassBaseTest;
import com.live.enums.RequestType;
import org.testng.Assert;
import org.testng.annotations.Test;

/**
 * 文件列表，自行判断用户id
 *
 * @author xue.w
 * @since 2020/09/16 at  6:03 下午
 **/
public class TestFolderList extends CloudClassBaseTest {
    @Override
    public String getApiName() {
        return "API_folderList";
    }

    @Test(description = "获取文件列表")
    public void testFolderList(){
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current","1");
        jsonObject.put("disk", "MYSELF");
        jsonObject.put("size", Integer.toString(Integer.MAX_VALUE));

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        System.out.println(jsonBody);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals(jsonBody.getJSONObject("result").getString("total"), Integer.toString(jsonBody.getJSONObject("result").getJSONArray("records").size()));

    }
}
