package com.live.xmutils;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.BaseTest;
import com.live.enums.ApiModele;
import com.live.enums.Terminal;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

/**
 * Created by wujie on  2020/10/11
 */
public abstract class AppApiBaseTest extends ApiBaseTest {
    @BeforeClass
    public static void beforeClass() {
        BaseTest.beforeClass();
    }

    @AfterClass
    public static void afterClass() {
        BaseTest.afterClass();
    }

    @BeforeMethod
    public void beforeTest() {
        //设置测试信息：env、Apimodule、Apiname、接口账号信息、端口位
        xmAppApi.setApiModule(ApiModele.CloudClass_Video) // API 所属模块
                .setApiName(getApiName()) // API 名称
                .setEnv("prod")            // 运行环境
                .setLoginUser("wujie_b")         // 测试账号
                .setTerminal(Terminal.C);             // 所属端位（B端，C端，M端等, 必传）

        /*dal.setCase_owner("wujie")
            .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);*/

        super.beforeTest();
    }

    @AfterMethod
    public void afterTest(ITestResult result) {
        super.afterMethod(result);
    }


    /**
     *
     * @return
     */
    protected abstract String getApiName();

//    protected String getTerminal(){
//        return "Terminal.B";
//    };

    //protected abstract String getApiModule();

    protected static JSONObject doRequest(String data){

        okHttpClient.doPostRequest(url,data,headers);
        JSONObject jsonBody = okHttpClient.getBodyInJSON();

        return jsonBody;
    }
}
