package com.live.cases.musicPlay;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2021/1/28
 */

public class TestGetOnlyOneClassLiveList extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getOnlyOneClassLiveList") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试乐器陪练课列表-默认查询条件
     */
    @Test
    public void testGetOnlyOneClassLiveList() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId","1235115978015883266");
        jsonObject.put("current","1");
        jsonObject.put("size","10");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

    /**
     * 测试乐器陪练课列表-全部查询条件
     */
    @Test
    public void testGetOnlyOneClassLiveList1() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("instId","1235115978015883266");
        jsonObject.put("current","1");
        jsonObject.put("size","10");
        jsonObject.put("courseName","zy乐器陪练自动化测试");
        jsonObject.put("courseState","FINISH");
        jsonObject.put("endTime","1612454399999");
        jsonObject.put("teacherId","1235115979473997826");
        jsonObject.put("teacherName","主账户老师");

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        Assert.assertEquals("1", jsonBody.getJSONObject("result").getString("total"));
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }


}
