package com.live.cases.musicPlay;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetOnlyOneClassLiveListData;
import com.live.xmutils.GetOnlyOneCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangying
 * @date 2021/2/7 4:55 下午
 */
public class TestAddCourseStu extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_addCourseStu") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        super.beforeTest();
        System.out.println(xmAppApi);
    }

    /**
     * 测试乐器陪练课-添加学员"不扣课时学员（自动化测试）"
     */

    @Test
    public void testAddCourseStu() {
        GetOnlyOneCourseData onlyOneCourseData = new GetOnlyOneCourseData();
        JSONObject onlyOneClassCourse = onlyOneCourseData.creatOnlyOneCourse();
        System.out.println("onlyOneClassCourse = "+onlyOneClassCourse);

        String liveCourseId = onlyOneClassCourse.getString("result");

        String studentId = "1358297612940660738";
        List studentIds = new ArrayList();
        studentIds.add(studentId);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId",liveCourseId);
        jsonObject.put("studentIds",studentIds);

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);

        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody);

        JSONObject onlyOneCourseList = onlyOneCourseData.getOnlyOneCourseList();
        String studentId1 = onlyOneCourseList.getJSONObject("result").getJSONArray("records").getJSONObject(0).getJSONArray("liveStudentBaseVO").getJSONObject(0).getString("studentId");
        System.out.println("onlyOneCourseList = "+onlyOneCourseList);

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
        Assert.assertEquals(studentId, studentId1);

    }
}
