package com.live.xmutils;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.RandomStringUtil;
import com.live.utils.XMBaseTest;

import java.util.HashMap;
import java.util.Map;

public class GetLiveCourseData extends XMBaseTest {

    public JSONObject getLargeClassLiveList() {

        dataApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getLargeClassLiveList") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）

        super.beforeDataRequest();


        Map bodyMap = new HashMap();
        bodyMap.put("current", 1);
        bodyMap.put("instId", "1235115978015883266");
        bodyMap.put("size", 10);
        String bodydata = JSONObject.toJSONString(bodyMap);

        dataApi.doRequest(RequestType.JSON, params, bodydata, dataheadrs);

        JSONObject liveCourseList=dataApi.getBodyInJSON();

        return liveCourseList;
    }

    public JSONObject createLargeClassLive() {
        dataApi.setApiModule(ApiModele.CloudClass_B)
                .setApiName("API_createLargeClassLive")
                .setLoginUser("zhangy-b")
                .setTerminal(com.live.enums.Terminal.B);
        super.beforeDataRequest();


        dataApi.doRequest(RequestType.JSON, params, buildCreateLargeClassLiveParam().toJSONString(), dataheadrs);

        JSONObject liveCourse=dataApi.getBodyInJSON();
        return liveCourse;
    }

    //组装大班直播新增的数据
    public JSONObject buildCreateLargeClassLiveParam() {
        JSONObject largeClassLive = new JSONObject();
        largeClassLive.put("courseName", RandomStringUtil.randomNumber(14, "live_course_"));
        largeClassLive.put("teacherId",xmAppApi.getLoginInfo().getTid());
        largeClassLive.put("startTime",System.currentTimeMillis() + 60 * 1000);
        largeClassLive.put("endTime",System.currentTimeMillis() + 30 * 60 * 1000);
        largeClassLive.put("needRecord","YES");
        largeClassLive.put("liveType","LARGE_CLASS_LIVE");
        largeClassLive.put("consumeHourNum",1);
        largeClassLive.put("consumeClassTime","1");

        return largeClassLive;
    }


}
