package com.live.cases.interactionLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Created by zhangying on  2020/02/03
 */

public  class TestQueryStudentVisitData extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_queryStudentVisitData") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 大班互动直播课-学员上课数据
     */
    @Test
    public void testQueryStudentVisitData() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("liveCourseId","1356798987214893057");
        jsonObject.put("nameOrPhone","");
        jsonObject.put("current","1");
        jsonObject.put("size","10000");
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("jsonBody ="+jsonBody );

        Assert.assertNotEquals(0, jsonBody.getString("total"));
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));

    }

}
