package com.live.cases.largeClassLive;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhangying on  2020/02/02
 */

public  class TestConvertShortUrls extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_B) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_convertShortUrls") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 直播课分享
     */
    @Test
    public void testConvertShortUrls() {

        String urls="https://prod.xiaomai5.com/share/show?appid=wxdd6b458500d4c224&redirect_uri=https%3A%2F%2Fres" +
                ".xiaomai5.com%2Fxiaomai-live-share%2Findex.html%23%2FliveShare%3Fid%3D1356196461296828418%26saasVersio" +
                "n%3DV_50%26appid%3Dwxdd6b458500d4c224&response_type=code&scope=snsapi_base&state=state#wechat_redirect";

        List urlsList = new ArrayList();
        urlsList.add(urls);
        System.out.println("urlsList ="+urlsList );

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("urls",urlsList);
        System.out.println("jsonObject ="+jsonObject );

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();
        System.out.println("courseName ="+jsonBody.getJSONArray("result").getJSONObject(0));

        Assert.assertEquals(jsonBody.getJSONArray("result").getJSONObject(0).getString("shortUrl"),"http://ixm5.cn/593wP");
        Assert.assertEquals(jsonBody.getJSONArray("result").getJSONObject(0).getString("url"), urls);
        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

}
