package com.live.cases.seriesCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetSeriesCourseData;
import com.live.xmutils.GetVideoClassData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/23 3:41 下午
 */
public class TestEditSeriesSchedule extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_editSeriesSchedule") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    @Test
    public void testEditSeriesSchedule(){

        GetVideoClassData getVideoClassData = new GetVideoClassData();
        String scheduleId = getVideoClassData.VideoClassData().getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        GetSeriesCourseData getSeriesCourseData = new GetSeriesCourseData();
        String seriesId = getSeriesCourseData.createSeriesCourse();

        List scheduleIds = new ArrayList();
        scheduleIds.add(scheduleId);

        Map bodyMap = new HashMap();
        bodyMap.put("seriesId",seriesId);
        bodyMap.put("scheduleIds",scheduleIds);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));


    }


}
