package com.live.cases.seriesCourse;

import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetSeriesCourseData;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/24 3:49 下午
 */
public class TestMoveSeriesSchedule extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Series) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_moveSeriesSchedule") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }
    @Test
    public void testMoveSeriesSchedule1(){

        GetSeriesCourseData getSeriesCourseData = new GetSeriesCourseData();
        String seriesId = getSeriesCourseData.getSeriesScheduleIdList().getString("seriesId");

        String scheduleId = getSeriesCourseData.getSeriesScheduleIdList().getJSONArray("result").getString(1);

        Map bodyMap = new HashMap();
        bodyMap.put("seriesId",seriesId);
        bodyMap.put("scheduleId",scheduleId);
        bodyMap.put("newSequence",1);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));

    }

    @Test
    public void testMoveSeriesSchedule2(){

        GetSeriesCourseData getSeriesCourseData = new GetSeriesCourseData();
        String seriesId = getSeriesCourseData.getSeriesScheduleIdList().getString("seriesId");

        String scheduleId = getSeriesCourseData.getSeriesScheduleIdList().getJSONArray("result").getString(0);

        Map bodyMap = new HashMap();
        bodyMap.put("seriesId",seriesId);
        bodyMap.put("scheduleId",scheduleId);
        bodyMap.put("newSequence",2);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("200", jsonBody.getString("code"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));


    }
}
