package com.live.cases.videoCourse;

import com.live.enums.ApiModele;
import com.live.enums.RequestType;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import com.live.xmutils.GetVideoClassData;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fym
 * @date 2021/2/23 11:47 上午
 */
public class TestGetLessonStuIdListByScheduleId extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_Video) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_getLessonStuIdListByScheduleId") // API 名称  必传
                .setLoginUser("fym-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("樊圆梦");
        super.beforeTest();
    }

    @Test
    public void testGetLessonStuIdListByScheduleId() throws InterruptedException {

        GetVideoClassData getVideoClassData = new GetVideoClassData();
        String scheduleId = getVideoClassData.addLessonScheduleStu();

        Map bodyMap = new HashMap();
        bodyMap.put("scheduleId",scheduleId);

        JSONObject jsonObject = new JSONObject(bodyMap);
        String bodyData = jsonObject.toString();

        xmAppApi.doRequest(RequestType.JSON, params, bodyData, headers);
        System.out.println(xmAppApi);
        com.alibaba.fastjson.JSONObject jsonBody = xmAppApi.getBodyInJSON();

        Assert.assertEquals("1308376918943268866",jsonBody.getJSONArray("result").getString(0));




    }

}
