package com.live.cases.fileManage.commonFolder;


import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zhangying on  2020/11/19
 */

public class TestMultiPartUpload extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_File) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("API_multiPartUpload") // API 名称  必传
                .setEnv("prod")             // 运行环境   测试时可指定自己要运行的环境。 不穿默认取系统指定的允许环境
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("张莹");
        super.beforeTest();
    }

    /**
     * 测试资料云盘-文件夹中上传pptx文件
     */
    @Test
    public void testMultiPartUpload() {
        Map contentMap = new HashMap();
        contentMap.put("folderId","1328233404495687681");
        System.out.println("contentMap= "+contentMap);

        Map bodyMap = new HashMap();
        bodyMap.put("accessTypeEnum", "PUBLIC");
        bodyMap.put("bizCode", "UPLOAD_FOLDER");
        bodyMap.put("data", contentMap);
        bodyMap.put("instId", xmAppApi.getLoginInfo().getInstId());
        bodyMap.put("resourceName", "XWX8GXcwRaHmicrZ.pptx");
        System.out.println("bodyMap = "+bodyMap);

        String bodydata = JSONObject.toJSONString(bodyMap);

        xmAppApi.doPost(okHttpClient, url, params, bodydata , headers);
        JSONObject jsonBody = okHttpClient.getBodyInJSON();

        Assert.assertEquals("true", jsonBody.getString("success"));
        Assert.assertEquals("操作成功!", jsonBody.getString("message"));
//        Assert.assertEquals(jsonBody.getJSONObject("result").getString("total"), Integer.toString(jsonBody.getJSONObject("result").getJSONArray("records").size()));
    }
}

