package com.live.cases.liveClientT.cloundClass;


import com.alibaba.fastjson.JSONObject;
import com.live.enums.ApiModele;
import com.live.enums.Terminal;
import com.live.utils.XMBaseTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

import static io.restassured.RestAssured.given;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by zhangying on  2020/11/16
 */

public class TestQueryLiveAccount extends XMBaseTest {

    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModele.CloudClass_apollo) // API 所属模块  必传 读取配置文件config.properties配置的api地址
                .setApiName("api_queryLiveAccount") // API 名称  必传
                .setLoginUser("zhangy-b")         // http 接口，测试账号 必传
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
                dal.setCase_owner("zhangying")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    /**
     * 测试资料云盘-新增保存文件夹
     */
    @Test
    public void testQueryLiveAccount() {

        Map bodyMap = new HashMap();
        bodyMap.put("instId", "1235115978015883266");


        String bodydata = JSONObject.toJSONString(bodyMap);

        // 接口请求 返回responseBody
        given()
                .header("Content-Type", "application/json")
                .queryParams(params)
                .headers(headers)
                .body(bodydata)
                .when()
                .post(xmAppApi.getUrl())
                .then().log().all()
                .body("success", equalTo(true));
    }
}

