package com.xiaomai.cases.polar.charts;

import com.xiaomai.cases.polar.export.ExportTool;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestFetchPageOfMemberRank extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Charts)
                .setApiName("API_fetchPageOfMemberRank")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    ChartsTools chartsTools = new ChartsTools();
    ExportTool exportTool =new ExportTool();
    @Test(description = "会员排行榜列表")
    public void testfetchPageOfMemberRank() throws InterruptedException {
        chartsTools.memberRankListsaveRule1("","1");//恢复规则设置默认规则
        chartsTools.findRule();//查看规则
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.monthRankTitle"), "内卷自动化", "默认规则榜单名称未设置成功");//断言月榜名称为：内卷自动化
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.monthRandThreshold"), "1", "默认规则月榜条件未设置成功");//断言月榜上榜条件为1
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.openSeasonRank"), "NO", "默认规则月榜条件未设置成功");//断言季度榜未开启
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.openYearRank"), "NO", "默认规则月榜条件未设置成功");//断言年度榜未开启
        chartsTools.fetchPageOfMemberRank("MONTH", TimeUtils.getMonthFristDay(),TimeUtils.getMonthLastDay());//会员排行榜月榜


        String reward ="{\"items\":[{\"aspect\":\"\",\"type\":\"TEXT\",\"content\":\"B端自动化奖励规则\"}]}";
        chartsTools.memberRankListsaveRule("YES","YES",reward,"1","月榜自动化","1","季榜自动化","1","年榜自动化");//设置季度、年榜
        chartsTools.findRule();//查看规则
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.openSeasonRank"), "YES", "季度榜未开启");//断言季度榜开启
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.seasonRankThreshold"), "1", "季度榜未开启");//断言季度榜上榜条件为1
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.openYearRank"), "YES", "年度榜未开启");//断言年度榜开启
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.yearRankThreshold"), "1", "季度榜未开启");//断言年度榜上榜条件为1


        chartsTools.fetchPageOfMemberRankofmember("YEAR","1805435813468483586",TimeUtils.getStartYear(),TimeUtils.getEndYear());//一年（年榜）会员排榜榜搜索会员：C端自动化会员
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].rankOrder"), "1", "目标学员非第一名");//由于会员排榜榜每五分钟刷新一次，所以我取点名次数最多的学员

        chartsTools.memberRankList_export("MONTH",TimeUtils.getMonthFristDay(),TimeUtils.getMonthLastDay());//月榜导出
        exportTool.pageStudioExportRecord();//查看导出记录
        Thread.sleep(2000);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].workflowName"), "导出排行榜", "未生成导出记录");//断言有导出记录






    }
}
