package com.xiaomai.cases.polar.experienceCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author zxy
 * @Description
 * @Date 2024/8/8 14:04
 */
public class TestUpdateExperienceCard extends XMBaseTest {
    Tools tools = new Tools();
    CardTools cardTools = new CardTools();
    String memberCardId;
    String title;
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_tenantMemberCard_update")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "编辑体验卡")
    public void testUpdateExperienceCard() throws InterruptedException {

        //先检查下列表有没有数据，有数据才会执行下面的点代码,无数据则新建一个
        cardTools.fetchPageOfMemberCard("EXPERIENCE_CARD");
        int listDatas = XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(), "$.result.records").size();
        if (listDatas > 0) {
            memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");
            }
        else {
            for(int i=0;i<3;i++){
                title = "课程次数入场次数"+ RandomStringUtil.randomString(3)+"-自动化创建";
                //check是否存在同名的体验卡，不存在则新建
                Boolean duplicate = tools.checkTitleDuplicate(title, "EXPERIENCE_CARD").getBoolean("result");
                if (duplicate == false) {
                    Thread.sleep(2000);
                    memberCardId = tools.create("EXPERIENCE_CARD",title,"全部","YES","课程次数入场次数",false).getString("result");
                    break;
                }
            }
        }
        //编辑体验卡前的查看编辑记录列表的总数
        int num = Integer.parseInt(cardTools.fetchPageOfHistory(memberCardId).getJSONObject("result").getString("total"));

        //从体验卡详情获取部分字段信息
        JSONObject res = cardTools.fetchDetailById(memberCardId).getJSONObject("result");
        List activatePatternList = res.getJSONArray("activatePatternList");
        List benefitList = res.getJSONArray("benefitList");
        String price = res.getString("price");

        //购买体验卡的会员状态：仅潜在会员
        List purchaseMemberStateList = new ArrayList();
        purchaseMemberStateList.add("POTENTIAL");

        String description = "{\"items\":[{\"aspect\":\"\",\"type\":\"TEXT\",\"content\":\"自动化测试脚本编辑\"}]}";

        //编辑体验卡
        JSONObject object = new JSONObject();
        object.put("brandId", dataApi.getLoginInfo().getBrandId());
        object.put("studioId", dataApi.getLoginInfo().getStudioId());
        object.put("operatorId", dataApi.getLoginInfo().getAdminId());
        object.put("creatorId", dataApi.getLoginInfo().getAdminId());
        object.put("maxIdlePeriod", "7");//首次使用生效方式的最晚生效天数
        object.put("useForActivity", "false");//不开启用于营销活动

        object.put("surfaceCornerMark", "自动化测试");//封面标签
        object.put("title", title);
        object.put("validPeriod", "10");//有效期
        object.put("activatePatternList", activatePatternList);//生效方式
        object.put("price", price);//售价
        object.put("underlinePrice", "35");//划线价
        object.put("purchaseNumberLimit", "100");//最大购买数量
        object.put("xcxSaleStatus", "YES");//开启小程序售卖
        object.put("shelfState", "YES");//启用体验卡
        object.put("description", description);//描述
        object.put("benefitList", benefitList);//权益信息
        object.put("stock","");//剩余库存
        object.put("purchaseMemberStateList", purchaseMemberStateList);//可购卡的会员状态
        object.put("surfaceUrl", "https://image.xiaomaiketang.com/xm/internal/AHZTicf2k7.png");//封面
        object.put("commodityCardType", "EXPERIENCE_CARD");//卡类型：体验卡
        object.put("purchaseRestriction","NO");
        object.put("memberCardId",memberCardId);

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

        JSONObject res1 = cardTools.fetchPageOfHistory(memberCardId).getJSONObject("result");
        Assert.assertEquals(res1.getString("total"),String.valueOf(num+1));//编辑记录应该+1条
        Assert.assertEquals(res1.getJSONArray("records").getJSONObject(0).getString("operateType"),"EDIT");//最新的一条应该是编辑的

        JSONObject res2 = cardTools.findHistoryDetailById(res1.getJSONArray("records").getJSONObject(0).getString("snapshotId")).getJSONObject("result");
        Assert.assertEquals(res2.getString("purchaseRestriction"),"NO");
        Assert.assertEquals(res2.getJSONArray("purchaseMemberStateList"),purchaseMemberStateList);



    }
}
