package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.UUID;

public class TestTrainingTemplateEdit extends BaseTestImpl {

    @Resource(name="trainingTools")
    TrainingTools trainingTools;

    String templateName = "训练模板";
    String itemName = "饮食搭配";//模板内容标题
    String itemType = "GRAPHIC";//模板内容类型

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Training,"API_trainingTemplateEdit", LoginAccount.GYM_PROD, Terminal.B,"xyy");
        super.beforeTest();
    }
    @Test(description = "创建模板>查看模板详情>编辑模板>删除模板")
    public void testTrainingExerciseEdit()throws InterruptedException{
        //1.检验名称是否重名，若重名则换一个名称
        boolean flag = trainingTools.trainingTemplateCheckName("",templateName);
        if(flag==false){
            templateName = "训练模板"+ RandomStringUtil.randomString(5);
        }

        //获取模板数据
        int num = Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingTemplateListPage(templateName),"$.result.total"));

        //2.创建训练模板
        String templateId = trainingTools.trainingTemplateCreate(itemType,itemName,templateName);
        Thread.sleep(3000);
        //检验模板数据+1
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingTemplateListPage(templateName),"$.result.total"))==num+1);

        //检验模板详情，模板名称正确、训练内容有值；
        Assert.assertEquals(XMJSONPath.readPath(trainingTools.trainingTemplateDetail(templateId),"$.result.templateName"),templateName);
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(trainingTools.trainingTemplateDetail(templateId),"$.result.templateItemList").size()>0);

        //3.编辑模板
        JSONObject exercise = new JSONObject();
        exercise.put("objectId", UUID.randomUUID().toString());
        exercise.put("itemName","编辑热身运动");
        exercise.put("itemType","EXERCISE");//动作EXERCISE

        JSONArray itemList = new JSONArray();
        itemList.add(exercise);

        JSONObject body = new JSONObject();
        body.put("trainingTemplateName",templateName);
        body.put("trainingTemplateItemList",itemList);
        body.put("templateId",templateId);
        body.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("creator",xmAppApi.getLoginInfo().getAdminId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        //检验动作详情，训练内容有值；
        Assert.assertTrue(XMJSONPath.getJSONArrayByReadPath(trainingTools.trainingTemplateDetail(templateId),"$.result.templateItemList").size()>0);

        //4.删除模板
        trainingTools.trainingTemplateDelete(templateId);
        //检验模板数据保持跟原来一致
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.trainingTemplateListPage(templateName),"$.result.total"))==num);
    }
}
