package com.xiaomai.cases.polar.data;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestGetCourseCostDetail extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Data)
                .setApiName("API_getCourseCostDetail")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "数据中心-上课数据-课消明细-团课")
    public void testgetCourseCostDetail() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("coachId","");
        jsonObject.put("dateType","DAY");
        jsonObject.put("sort","TOTAL_COST_DESC");
        jsonObject.put("consumeType","GROUP_CLASS");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "数据中心-上课数据-课消明细-私教课")
    public void testgetCourseCostDetail1() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("coachId","");
        jsonObject.put("dateType","DAY");
        jsonObject.put("sort","TOTAL_COST_DESC");
        jsonObject.put("consumeType","PERSONAL");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
    @Test(description = "数据中心-上课数据-课消明细-训练营")
    public void testgetCourseCostDetail2() {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("coachId","");
        jsonObject.put("dateType","DAY");
        jsonObject.put("sort","TOTAL_COST_DESC");
        jsonObject.put("consumeType","TRAINING_CAMP");
        jsonObject.put("endTime", TimeUtils.getWeekLastTime());
        jsonObject.put("startTime",TimeUtils.getWeekFirstTime());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
}
