package com.xiaomai.cases.polar.eleContract;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.eleContract
 * @Author: xuyamei
 * @CreateTime: 2024-08-05  14:55
 * @Description: 获取租户有效余额记录
 * @Version: 1.0
 */
public class TestGetValidBalanceList extends BaseTestImpl {
    @Resource(name = "eleContractTools")
    EleContractTools eleContractTools;

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_EleContract,"API_getValidBalanceList", LoginAccount.DZHT_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testGetValidBalanceList() {
        JSONObject body = new JSONObject();
        body.put("tenantId", xmAppApi.getLoginInfo().getStudioId());
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);
        Assert.assertTrue(xmAppApi.getBodyInJSON().getJSONArray("result").size() > 0, "获取租户有效余额记录失败");
        // 和充值记录的数据对比
        String[] keys = {"id", "tenantId", "productCode", "purchaseAmount", "startTime", "endTime", "payChannel"};

        int total = xmAppApi.getBodyInJSON().getJSONArray("result").size();

        List<JSONObject> list1 = new ArrayList<>();
        List<JSONObject> list2 = new ArrayList<>();
        for (int i = 0; i < total; i++) {
            list1.add(eleContractTools.getBalanceList().getJSONObject(i));
            list2.add(xmAppApi.getBodyInJSON().getJSONArray("result").getJSONObject(i));
        }

        int flag = 1;
        for (int i = 0; i < total; i++) {
            for (int j = 0; j < keys.length; j++) {
                String expected = list1.get(i).getString(keys[j]);
                String actual = list2.get(total - flag).getString(keys[j]);
                Assert.assertEquals(actual, expected, "获取租户有效余额记录与充值记录列表内容对比");
            }
            flag++;
        }

    }
}
