package com.xiaomai.cases.polar.finance.cashier;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestPage extends XMBaseTest {

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_page")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @DataProvider
    public Object[][] dataProvider(){
        return new Object[][]{
                {"自动化流水",null},
                {null,"10020060066"},
        };
    }

    @Test(description = "分页筛选收银流水-搜索",dataProvider ="dataProvider")
    public void testPage(String buyerName,String buyerPhone){

        //10020060066--固定流水，换场馆需要按照这个手机支付0.01元 "flowIds": ["1808757176611880962"]
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("buyerName",buyerName);
        jsonObject.put("buyerPhone",buyerPhone);
        jsonObject.put("businessNo",null);
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);

        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        int total=Integer.parseInt(response.getJSONObject("result").getString("total"));
        Assert.assertEquals(success,"true","分页筛选收银流水失败");
        Assert.assertEquals(total>=1,true,"未搜索到对应的流水");
    }


    @DataProvider
    public Object[][] dataProvider1(){
        return new Object[][]{
                {true,"WX","PAY_QR_CODE","REFUND"},
                {false,"ALI","SIGN_ORDER","PAY"},
                {false,"ALI","REFUND_ORDER","REFUND"},
                {false,"WX","DISCARD_ORDER","PAY"},

        };
    }
    @Test(description = "分页筛选收银流水",dataProvider = "dataProvider1")
    public void testPage_sift(boolean existSubOrderNo,String subChannel,String orderType,String transType){

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("current",0);
        jsonObject.put("size",20);
        jsonObject.put("buyerName",null);
        jsonObject.put("buyerPhone","10020060066");
        jsonObject.put("businessNo",null);
        jsonObject.put("existSubOrderNo",existSubOrderNo);//是否存在子订单号, true-存在；false-不存在
        jsonObject.put("subChannel",subChannel);//支付方式 [ "支付宝", "微信" ] [ ALI, WX ]
        JSONArray transStateList=new JSONArray();//收款成功（入账中、入账成功）
        transStateList.add("PAY_SUCCESS");
        transStateList.add("PAY_IN");
        jsonObject.put("transStateList",transStateList);

        jsonObject.put("orderType",orderType);//来源[ "未知", "签单", "退单", "作废订单", "收款码", "B端短信充值", "电子合同" ][ UNKNOWN, SIGN_ORDER, REFUND_ORDER, DISCARD_ORDER, PAY_QR_CODE, B_SMS_RECHARGE, ELE_CONTRACT ]
        jsonObject.put("transType",transType);//交易类型：PAY-收款；REFUND-退款；
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        String success=xmAppApi.getBodyInJSON().getString("success");
        Assert.assertEquals(success,"true","分页筛选收银流水失败");

    }


}
