package com.xiaomai.cases.polar.invitationGifts;

import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.cases.polar.coupon.CouponTools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestJoinActivity extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Lunar_Invitation)
                .setApiName("API_joinActivity")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);
        dal.setCase_owner("yangjian")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    DataUserInfo info = new DataUserInfo();

    @Resource(name = "InvitationGiftsTools")
    InvitationGiftsTools InvitationGiftsTools;

    @Resource(name = "couponTools")
    CouponTools couponTools;

    @Resource(name = "InvitationGiftsMinTools")
    InvitationGiftsMinTools invitationGiftsMinTools;

    @Resource(name = "userTools")
    UserTools userTools;

    @Resource(name = "memberTools")
    MemberTools memberTools;

    @Test(description = "参与邀请有礼活动")
    public void testJoinActivity() throws InterruptedException {

        String memberId = userTools.getMemberInfo().getString("memberId");//邀请人

        info.setTerminal(Terminal.B);
        info.setLoginUser(LoginAccount.GYM_PROD);

        String name = "自动化被邀请人"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("111");

        String memberId1 = memberTools.create(name,phone,info).getString("result");//被邀请人创建

        String couponName = "邀请优惠券" + RandomStringUtil.randomString(5);//优惠券名称
        String activityName = "邀请有礼活动" + RandomStringUtil.randomString(5);//活动名称
        String couponId = couponTools.createStudioCoupon("WITHOUT",couponName,true,info);//创建优惠券，拿优惠券ID

        String activeId =InvitationGiftsTools.createInvitationActivity(activityName,"NO_CONSUME", TimeUtils.getTodayEndTime(),TimeUtils.getTodayTime(),true,couponId,couponId,couponId,couponId,"COUPON","COUPON","COUPON","COUPON",info).getString("result");//创建发布的邀请有礼活动;

        int before = Integer.parseInt(XMJSONPath.readPath(InvitationGiftsTools.getInvitationActivityDetail(activeId,info), "$.result.promotedNum"));//B端初始推广人数
        int before1 = Integer.parseInt(XMJSONPath.readPath(InvitationGiftsTools.getInvitationActivityDetail(activeId,info), "$.result.invitedNum"));//B端初始受邀人数


        invitationGiftsMinTools.promoteActivity(memberId,activeId);//生成推广记录
        String promoteRecordId=XMJSONPath.readPath(dataApi.getApi_response(),"$.result");//获取推广ID


        int after = Integer.parseInt(XMJSONPath.readPath(InvitationGiftsTools.getInvitationActivityDetail(activeId,info), "$.result.promotedNum"));//B端推广后的人数
        Assert.assertEquals(after,before+1);//生成推广记录后，推广人数+1

        invitationGiftsMinTools.joinActivity(memberId1,promoteRecordId);//潜在会员参与活动
        int after1 = Integer.parseInt(XMJSONPath.readPath(InvitationGiftsTools.getInvitationActivityDetail(activeId,info), "$.result.invitedNum"));//B端参与活动后的受邀人数
        Assert.assertEquals(after1,before1+1);//生成推广记录后，推广人数+1

        Thread.sleep(2000);
        InvitationGiftsTools.InvitationGetStudioStatisticsData(activeId,null,null,info);//查看活动数据概括、
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.promotedNum"), "1", "邀请有礼推广失败");//断言目标活动推广人数为1
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.invitedNum"), "1", "邀请有礼受邀失败");//断言目标活动受邀请人数为1

        InvitationGiftsTools.getPromoteRecordPage(activeId,null,null,null,info);//查看活动推广名单
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].promoterInfo.id"), memberId, "目标推广人不正确");//断言推广人为目标人员

        InvitationGiftsTools.getJoinedRecordPage(activeId,info);//查看活动受邀名单
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].inviteeInfo.id"), memberId1, "目标受邀请人不正确");//断言受邀人为目标人员

        InvitationGiftsTools.getRewardSendRecordPage(activeId,info);//查看活动发放奖品
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].receivedMemberInfo.id"), memberId1, "C立即领取的奖励不是给受邀人员");//断言受邀人获取奖励

        couponTools.getCouponDetail(couponId,info);
        Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(), "$.result.received"), "1", "优惠券没有发放成功");//优惠券给受邀人发放



        InvitationGiftsTools.invitationActivityInvalid(activeId,info);


    }
}
