package com.xiaomai.cases.polar.setting.tag;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.admin.AdminTools;
import com.xiaomai.cases.polar.clue.MemberTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestEdit extends XMBaseTest {

    TagTools tagTools=new TagTools();
    MemberTools memberTools=new MemberTools();

    AdminTools adminTools=new AdminTools();

    String tagId1;
    String tagId2;
    String tagId3;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_tag_edit")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "编辑标签--未被会员使用")
    public void testEdit(){

        //添加标签
        JSONObject createTag=tagTools.tagCreate("自动化专用"+RandomStringUtil.randomString(2));
        tagId1=createTag.getString("result");

        //编辑标签
        JSONObject editTag=new JSONObject();
        editTag.put("bizAccountId",xmAppApi.getLoginInfo().getAdminId());
        editTag.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        editTag.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        editTag.put("label","自动化编辑"+RandomStringUtil.randomString(2));
        editTag.put("id",tagId1);

        xmAppApi.doRequest(RequestType.JSON,params,editTag.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getJSONObject("result").getString("success");
        Assert.assertEquals(success,"true","编辑标签失败");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test(description = "编辑标签--已被本场馆会员使用-同步编辑使用此标签会员的标签")
    public void testEdit_1(){

        //memberId：1801136353800269825-自动化标签会员勿动1（还不能删除线索，不添加这么多，暂时先用一个）

        //增加标签
        JSONObject createTag=tagTools.tagCreate("自动化标签勿动2");
        tagId2=createTag.getString("result");

        //获取当前员工昵称
        JSONObject nickNameResult=adminTools.getStudioAdmin(xmAppApi.getLoginInfo().getAdminId());
        String  nickName=nickNameResult.getJSONObject("result").getString("nickName");

        //给会员添加标签
        JSONObject forceUpdate=tagTools.forceUpdate("1801136353800269825","自动化标签会员勿动1",nickName,"10022233333","POTENTIAL",tagId2);

        //编辑标签
        JSONObject editTag1=new JSONObject();
        editTag1.put("bizAccountId",xmAppApi.getLoginInfo().getAdminId());
        editTag1.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        editTag1.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        editTag1.put("label","自动化编辑呀");
        editTag1.put("id",tagId2);
        editTag1.put("confirm",true);

        xmAppApi.doRequest(RequestType.JSON,params,editTag1.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getJSONObject("result").getString("success");
        Assert.assertEquals(success,"true","已被本场馆使用标签编辑失败");


        //验证标签更新
        //查询当前标签列表中这个标签名有没有更新
        JSONObject fetchPage=tagTools.tagFetchPage("自动化编辑呀");
        int total=Integer.parseInt(fetchPage.getJSONObject("result").getString("total"));
        Assert.assertEquals(1,total,"已被本场馆使用标签编辑失败");

        //查看会员详情的标签名有没有更新
        JSONObject findDetailById=memberTools.getDetailById("1801136353800269825");
        String label=findDetailById.getJSONObject("result").getJSONArray("tags").getJSONObject(0).getString("label");
        Assert.assertEquals(label,"自动化编辑呀","此标签被使用的会员未同步更新标签");

    }

    @Test(description = "编辑标签--已被非本场馆会员使用-不能编辑")
    public void testEdit_2() {
        //被别的场馆使用：tagId：1801151244447690753-自动化标签勿动;memberId：1801150921062658049-自动化标签会员勿动1
        //编辑标签
        JSONObject editTag2=new JSONObject();
        editTag2.put("bizAccountId",xmAppApi.getLoginInfo().getAdminId());
        editTag2.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        editTag2.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        editTag2.put("label","自动化编辑"+RandomStringUtil.randomString(2));
        editTag2.put("id","1801151244447690753");

        xmAppApi.doRequest(RequestType.JSON,params,editTag2.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getJSONObject("result").getString("success");
        Assert.assertEquals(success,"false","编辑已被非本场馆会员使用的标签失败");

    }

    @Test(description = "编辑标签--编辑相同标签名失败")
    public void testEdit_3() {
        //被别的场馆使用：tagId：1801151244447690753-自动化标签勿动;memberId：1801150921062658049-自动化标签会员勿动1

        //增加标签
        JSONObject createTag=tagTools.tagCreate("自动化标签勿动3");
        tagId3=createTag.getString("result");

        //编辑标签
        JSONObject editTag3=new JSONObject();
        editTag3.put("bizAccountId",xmAppApi.getLoginInfo().getAdminId());
        editTag3.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        editTag3.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        editTag3.put("label","自动化标签勿动");
        editTag3.put("id",tagId3);

        xmAppApi.doRequest(RequestType.JSON,params,editTag3.toJSONString(),headers).assetsSuccess(false);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        Assert.assertEquals(success,"false","相同标签名已存在，不可重复");

    }

    //删除标签
    @Test(description = "删除标签",priority = 1)
    public void deleteTag(){
        tagTools.tagDelete(tagId1);
        tagTools.tagDelete_Used(tagId2);
        tagTools.tagDelete(tagId3);
    }
}
