package com.xiaomai.client;

import io.restassured.response.Response;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

import static com.xiaomai.client.BaseTest.xmAppApi;
import static io.restassured.RestAssured.given;

/**
 * 封装RestAssuredRequest 类型的请求
 */
public class RestAssuredRequest {
    /**
     * 发送get请求
     * @param params
     * @param headers
     * @param url
     * @return
     */
    public static Response doGetRequestRA(IdentityHashMap<String, String> params, HashMap<String,String> headers, String url){

        Response response = given()
                .queryParams(params)
                .headers(headers)
                .when()
                .get(url)
                .then().log().all().extract().response();
        // 提取报告内容
        setReporterInfo(response,headers);

        return response;
    }

    /**
     * json格式参数post请求
     * @param params
     * @param headers
     * @param bodydata
     * @param url
     * @return   返回响应结果
     */
    public static Response doPostRequestRA(IdentityHashMap<String, String> params, HashMap<String,String> headers, String bodydata, String url){

        Response response = given()
                .queryParams(params)
                .headers(headers)
                .body(bodydata)
                .when()
                .post(url)
                .then().log().all().extract().response();
        // 提取报告内容
        setReporterInfo(response,bodydata,headers);

        return response;
    }

    /**
     * 没有请求头
     * @param headers
     * @param bodydata
     * @param url
     * @return
     */
    public static Response doPostRequestRA(HashMap<String,String> headers, String bodydata, String url){

        Response response = given()
                .headers(headers)
                .body(bodydata)
                .when()
                .post(url)
                .then().log().all().extract().response();
        setReporterInfo(response,bodydata,headers);
        return response;
    }

    /**
     * 没有请求参数
     * @param headers
     * @param url
     * @return
     */
    public static Response doPostRequestRA(IdentityHashMap<String, String> params,HashMap<String,String> headers, String url){

        Response response = given()
                .queryParams(params)
                .headers(headers)
                .when()
                .post(url)
                .then().log().all().extract().response();
        setReporterInfo(response,headers);
        return response;
    }

    /**
     * headers 增加appId
     * @param headers
     * @param bodydata
     * @param url
     * @return
     */
    public static Response doPostRequestRA(Map<String, String> params, HashMap<String,String> headers, String bodydata, String url){

        Response response = given()
                .queryParams(params)
                .headers(headers)
                .header("appId","wxdd6b458500d4c224")
                .body(bodydata)
                .when()
                .post(url)
                .then().log().all().extract().response();
        setReporterInfo(response,headers);
        return response;
    }

    /**
     * headers 增加appId,没有请求body
     * @param headers
     * @param url
     * @return
     */
    public static Response doPostRequestRA(HashMap<String,String> headers, String url){

        Response response = given()
                .headers(headers)
                .header("appId","wxdd6b458500d4c224")
                .when()
                .post(url)
                .then().log().all().extract().response();
        setReporterInfo(response,headers);
        return response;
    }

    /**
     * 设置测试报告提取信息
     * @param response  请求结果
     * @param bodydata  请求数据
     * @param headers  请求头
     */
    public static void setReporterInfo(Response response, String bodydata, HashMap<String, String> headers){
        // 提取报告内容
        xmAppApi.setApi_response(response.asString()) ;// 请求结果
        xmAppApi.setApi_traceId(response.getHeader("traceId")) ;// 结果traceId
        xmAppApi.setApi_request_data(bodydata); // 请求体
        xmAppApi.setApi_request_headers(headers) ;

    }
    public static void setReporterInfo(Response response,  HashMap<String, String> headers){
        // 提取报告内容
        xmAppApi.setApi_response(response.asString()) ;// 请求结果
        xmAppApi.setApi_traceId(response.getHeader("traceId")) ;// 结果traceId
        xmAppApi.setApi_request_headers(headers) ;

    }



}
