package com.xiaomai.cases.polar.finance.axf;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.axf
 * @Author: xuyamei
 * @CreateTime: 2024-12-25  14:14
 * @Description: 先享后付工具类
 * @Version: 1.0
 */
public class AXFTools extends XMBaseTest {
    public void setUp(String name, DataUserInfo...dataUserInfo) {
        dataApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName(name)
                .setTerminal(Terminal.B);
        super.beforeDataRequest(dataUserInfo);
    }


    /**
     * @description:查询先享后付订购单
     * @author: xuyamei
     * @date:  2024/12/25 14:15
     * @param body：请求参数
     * @return: com.alibaba.fastjson.JSONObject
     **/
    public JSONObject getAXFPageOrder(String body){
        setUp("API_axf_pageOrder");

        dataApi.doRequest(RequestType.JSON,dataparams,body,dataheadrs).assetsSuccess(true);
        return dataApi.getBodyInJSON();
    }



}
