package com.xiaomai.cases.polar.finance.axf;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases.polar.finance.axf
 * @Author: xuyamei
 * @CreateTime: 2024-12-25  16:05
 * @Description: 查看订购单详情
 * @Version: 1.0
 */
public class TestAXFGetOrder extends BaseTestImpl {
    AXFTools axfTools = new AXFTools();

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Finance,"API_axf_getOrder", LoginAccount.GYM_PROD, Terminal.B,"xym");
        super.beforeTest();
    }

    @Test
    public void testAXFGetOrder() {
        // 查询订购单列表数据
        String body = "{\"current\":0,\"size\":20,\"studioId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"commodityCardType\":\"DEPOSIT_CARD\",\"voucherBusinessNo\":null,\"thirdOrderNo\":null,\"operatorId\":\""+xmAppApi.getLoginInfo().getAdminId()+"\"}";
        JSONObject response = axfTools.getAXFPageOrder(body);
        String id = response.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        // 查询详订购单详情数据
        body = "{\"id\":\""+id+"\",\"studioId\":\""+xmAppApi.getLoginInfo().getStudioId()+"\",\"brandId\":\""+xmAppApi.getLoginInfo().getBrandId()+"\",\"operatorId\":\""+xmAppApi.getLoginInfo().getAdminId()+"\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        JSONObject response1 = xmAppApi.getBodyInJSON();

        String[] params = {"commodityId","id","instId","merchantId","originalPrice","receivedActualAmount","receivedAmount","receivedFee","receivedPeriod","signState","signTime","studentId","thirdOrderNo","totalPeriod","voucherBusinessNo","voucherId"};

        for (int i = 0; i < params.length; i++){
            String page = response.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString(params[i]);
            String detail = response1.getJSONObject("result").getString(params[i]);
            Assert.assertEquals(page,detail,"列表数据和详情一致");
        }

    }
}
