package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.List;

public class TestFetchUserCardList extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_fetchUserCardList")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "查看会员名下的已购会员卡")
    public void testfetchUserCardList() {
        JSONObject jsonObject = new JSONObject();

        List memberCardStateList = new ArrayList();
        memberCardStateList.add("UN_ACTIVE");
        memberCardStateList.add("NORMAL");
        memberCardStateList.add("SUSPEND");

        jsonObject.put("accountType","MEMBER");
        jsonObject.put("memberId","1801173772541014017");//后要变成会员id的变量
        jsonObject.put("memberCardStateList",memberCardStateList);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());



        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);

    }
}
