package com.xiaomai.cases.polar.finance.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.member.Tools;
import com.xiaomai.cases.polar.memberCard.CardTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.TimeUtils;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;
import java.util.UUID;

public class TestRefundOrderByDeposit extends XMBaseTest {
    String memberId;
    @Resource(name = "tools")
    Tools tools;
    @Resource(name = "orderTools")
    OrderTools orderTools;
    @Resource(name = "cardTools")
    CardTools cardTools;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_refundOrder")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "购买储值卡->使用储值购买会员卡->退会员卡->作废退会员卡->作废会员卡->作废储值卡")
    public void testRefundOrder_memberCard() throws InterruptedException{
        //定义会员名称和手机号
        String name = "储值卡会员"+ RandomStringUtil.randomString(3);
        String phone = RandomStringUtil.randomMobile("266");

        //获取会员id,没有则新建一个
        int memberTotal = Integer.parseInt(tools.search("NORMAL","NORMAL").getJSONObject("result").getString("total"));
        if (memberTotal == 0) {
            memberId = tools.create(name,phone).getString("result");
        }
        memberId = tools.search("NORMAL","NORMAL").getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        //获取启用中的会员卡id及价格
        String memberCardId = XMJSONPath.readPath(cardTools.fetchPageOfMemberCard("MEMBER_CARD"), "$.result.records[0].id") ;
        String price = XMJSONPath.readPath(cardTools.fetchPageOfMemberCard("MEMBER_CARD"), "$.result.records[0].price");
        String cardSnapshotId = XMJSONPath.readPath(cardTools.fetchDetailById(memberCardId), "$.result.latestSnapshotId");
        //获取启用中的储值卡id
        String cardId = XMJSONPath.readPath(cardTools.fetchPageOfMemberCard("DEPOSIT_CARD"), "$.result.records[0].id");
        String latestSnapshotId = XMJSONPath.readPath(cardTools.fetchDetailById(cardId), "$.result.latestSnapshotId");
        //1.购储值卡,获取购卡订单id
        String voucherId = cardTools.signOrderDeposit(cardId,latestSnapshotId,memberId,"0.00",price);
        Thread.sleep(3000);
        //通过搜索接口查询该会员名下第1张已售卖的储值卡
        String benefitId = XMJSONPath.readPath(orderTools.fetchUserCardList("DEPOSIT",memberId,"NORMAL"),"$.result[0].depositBenefit.id");
        String depositCardId = XMJSONPath.readPath(orderTools.fetchUserCardList("DEPOSIT",memberId,"NORMAL"),"$.result[0].id");
        String depositCardName = XMJSONPath.readPath(orderTools.fetchUserCardList("DEPOSIT",memberId,"NORMAL"),"$.result[0].title");
        //先查询消耗记录的条数
        int num = Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId),"$.result.total"));
        //2.使用储值卡购买会员卡产生的订单id
        String orderId = orderTools.signOrder(memberId,memberCardId,cardSnapshotId,price,depositCardId,depositCardName);
        String memberCardNo = XMJSONPath.readPath(orderTools.fetchUserCardList("MEMBER",memberId,"NORMAL"),"$.result[0].id");
        //储值卡消耗记录新增1条，类型为签单,消耗金额
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.total")) ==num+1);
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].consumeType"),"DEPOSIT_SIGN_ORDER");
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].changeOfGiveBalance"),"-"+price);
        //3.退会员卡
        JSONObject card = new JSONObject();
        card.put("giftQuantity",0);
        card.put("memberCardId",memberCardNo);
        card.put("quantity",10);
        card.put("entryQuantity",0);
        card.put("entryGiftQuantity",0);
        card.put("refundAmount",0);
        card.put("entryRefundAmount",0);
        card.put("commodityCardType","MEMBER_CARD");

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("operationTime", TimeUtils.getCurrentTime());
        jsonObject.put("card",card);
        jsonObject.put("objectId", UUID.randomUUID().toString());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("memberId",memberId);
        jsonObject.put("receivableAmount",0);
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        jsonObject.put("paymentWays",new JSONArray());
        jsonObject.put("depositRechargeAmount",0);
        jsonObject.put("depositGiveAmount",price);
        jsonObject.put("depositCardId",depositCardId);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        String refundOrderId = XMJSONPath.readPath(xmAppApi.getBodyInJSON(), "$.result");

        //储值卡消耗记录新增1条，类型为退单,增加金额
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.total")) ==num+2);
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].consumeType"),"DEPOSIT_REFUND_ORDER");
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].changeOfGiveBalance"),price);

        //4.作废退会员卡
        orderTools.discard(refundOrderId,"其他","自动化作废退会员卡订单");
        //储值卡消耗记录新增1条，类型为作废退单,消耗金额
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.total")) ==num+3);
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].consumeType"),"DEPOSIT_DISCARD_REFUND_ORDER");
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].changeOfGiveBalance"),"-"+price);

        //5.作废会员卡
        orderTools.discard(orderId,"其他","自动化作废会员卡订单");
        //储值卡消耗记录新增1条，类型为作废签单,增加金额
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.total")) ==num+4);
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].consumeType"),"DEPOSIT_DISCARD_SIGN_ORDER");
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].changeOfGiveBalance"),price);

        //6.作废储值卡
        orderTools.discard(voucherId,"其他","自动化作废储值卡订单");
        //储值卡消耗记录新增1条，类型为退单,消耗金额
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.total")) ==num+5);
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].consumeType"),"DISCARD_ORDER");
        Assert.assertEquals(XMJSONPath.readPath(cardTools.fetchPageOfConsumeRecord(benefitId,depositCardId), "$.result.records[0].changeOfGiveBalance"),"-"+price);

    }
}
