package com.xiaomai.cases.lunar.order;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.minmembercard.MinCardTools;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import java.math.BigDecimal;


public class TestMiNiPay extends BaseTestImpl {

    String memberId;

    String cardId;

    String pageOrderState;

    MinCardTools minCardTools=new MinCardTools();

    UserTools userTools=new UserTools();

    OrderCTools orderCTools=new OrderCTools();

    OrderTools orderTools=new OrderTools();

    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Lunar_Order,"API_miniPay", LoginAccount.GYM_MINIAPPC, Terminal.minApp,"yff");
        super.beforeTest();
    }


    @Test(description = "小程序支付")
    public void testMiNiPay() {


        //获取会员信息
        memberId = userTools.getMemberInfo().getString("memberId");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //获取会员卡

        JSONObject memberCardResult=minCardTools.fetchOnSaleMemberCard("次卡").getJSONObject("result").getJSONArray("records").getJSONObject(0);
        String id=memberCardResult.getString("id");

        //获取会员卡详情
        JSONObject memberCardDetailResult=orderCTools.findTenantCardDetailById(id,memberId);
        cardId= memberCardDetailResult.getJSONObject("result").getString("id");
        String latestSnapshotId= memberCardDetailResult.getJSONObject("result").getString("latestSnapshotId");
        BigDecimal price=new BigDecimal(memberCardDetailResult.getJSONObject("result").getString("price"));

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //购买C端非0元会员卡
        JSONObject purchaseCardResult=orderCTools.purchaseCard("PURCHASE",cardId,latestSnapshotId,memberId,price);
        String voucherId=purchaseCardResult.getJSONObject("result").getString("voucherId");//订单ID

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //小程序支付失败
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("appId",xmAppApi.getLoginInfo().getWechatAppId());
        System.out.println("yff"+xmAppApi.getLoginInfo().getWechatAppId());
        jsonObject.put("openId",xmAppApi.getLoginInfo().getOpenId());
        jsonObject.put("voucherId",voucherId);

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        String code=response.getString("code");
        Assert.assertEquals(success,"true","获取小程序支付失败");

//        如果把B端小麦乐动自动化场馆的收银信息改成微信未授权的，就是以下断言
//        Assert.assertEquals(code,"error/PAY_CENTER.PAY_FAIL_WX_AUTH","支付失败，请联系场馆工作人员进行微信授权。");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        //生成待支付订单
        //校验C端订单列表
        JSONObject pageOrder=orderCTools.pageOrder(memberId);
        int pageOrderPages=Integer.parseInt(pageOrder.getJSONObject("result").getString("pages"));
        int pageOrderTotal=Integer.parseInt(pageOrder.getJSONObject("result").getString("total"));


        for(int k=0; k == pageOrderPages+1; k++){
            int n =k==pageOrderPages ? (pageOrderTotal%10==0 ? 10 : pageOrderTotal%10) : 10;
            JSONArray records=pageOrder.getJSONObject("result").getJSONArray("records");
            boolean flag=true;
            for(int i=0; i<n; i++){
                String pageOrderId=records.getJSONObject(i).getString("id");
                pageOrderState=records.getJSONObject(i).getString("state");
                if(pageOrderId.equals(voucherId)){
                    flag = true;
                    break;
                }
            }
            Assert.assertEquals(true,flag,"在订单列表中未查询到创建的待支付签单订单");
            Assert.assertEquals(pageOrderState,"WAITING","未支付的C端的订单状态未是：待支付");
        }

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }

        //取消订单
        JSONObject cancelResult=orderCTools.cancel(voucherId);
        String result=cancelResult.getString("result");

        try {
            Thread.sleep(3000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        //切换B端验证

        DataUserInfo dataUserInfo = new DataUserInfo();
        dataUserInfo.setTerminal(Terminal.B);
        dataUserInfo.setLoginUser(LoginAccount.GYM_PROD);

        //校验获取B端签单订单详情：订单状态应是：已取消
        JSONObject getDetailBResult=orderTools.getDetail(voucherId,dataUserInfo);
        String getDetailBId = getDetailBResult.getJSONObject("result").getString("id");
        String getDetailBState = getDetailBResult.getJSONObject("result").getString("state");
        Assert.assertEquals(getDetailBId.equals(voucherId),true,"C端创建的签单订单在B端和C端展示的订单id不一致");
        Assert.assertEquals(getDetailBState,"CANCEL","C端订单C端取消订单之后，订单状态未变成已取消");


    }

}
