package com.xiaomai.cases.polar.brandMerchant;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.studioConfig.MerchantTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import javax.annotation.Resource;

/**
 * @Author: xyy
 * @CreateTime: 2024-04-23  11:48
 * @Description: 获取修改记录详情
 * @Version: 1.0
 */
public class TestGetApply extends XMBaseTest {

    @Resource(name = "merchantTools")
    MerchantTools merchantTools;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Merchant)
                .setApiName("API_getApply")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "获取修改记录详情")
    public void testPageApply() {

        //获取修改记录数据
        JSONObject body = merchantTools.getApplyPage();
        int total = Integer.parseInt(body.getJSONObject("result").getString("total"));
        //获取第1条修改记录
        String applyId = body.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");

        JSONObject object = new JSONObject();
        object.put("id", applyId);
        object.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        object.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        object.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON, params, object.toJSONString(), headers);
        JSONObject response = xmAppApi.getBodyInJSON();

        //若有数据，检验详情里的场馆信息跟品牌信息匹配；若无返回报错
        if (total != 0) {
            Assert.assertEquals(XMJSONPath.readPath(response, "$.message"), "操作成功!");
            Assert.assertEquals(XMJSONPath.readPath(response, "$.result.companyType"), "PRIVATE");
            Assert.assertEquals(XMJSONPath.readPath(response, "$.result.openState"), "SUCCESS");
        } else {
            Assert.assertEquals(XMJSONPath.readPath(response, "$.message"), "数据不存在");
        }
    }
}
