package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestDiscardManualDeduct extends XMBaseTest {

    @Resource(name = "cardTools")
    CardTools cardTools;

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Card)
                .setApiName("API_discardManualDeduct")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("yj")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }
    @Test(description = "撤销手动扣次")
    public void testDiscardManualDeduct() {
        cardTools.memberCardSearch("NORMAL");
        String benefitId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].courseBenefit.id");//拿售卖记录第一张【生效中】售卖的会员卡的ID;
        String memberCardId = XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");//拿售卖记录第一张【生效中】会员卡的ID;

        //JSONObject bodyJson1 =Cardtools.memberCardFindDetailById(memberCardId);
        //int num1 = Integer.parseInt(XMJSONPath.readPath(bodyJson1,"$.result.courseBenefit.leftPurchaseBalance"));

        cardTools.manualDeduct(benefitId,memberCardId);//手动扣次
        cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId);
        String consumeRecordId=XMJSONPath.readPath(dataApi.getApi_response(), "$.result.records[0].id");//拿第一条消耗记录
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].consumeType").equals("MANUAL_DEDUCT"),"操作手动扣次，消耗记录第一条操作类型");
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].changeOfPurchaseBalance").equals("-1.00"),"操作手动扣次，消耗次数");

        //JSONObject bodyJson2 =Cardtools.memberCardFindDetailById(memberCardId);
        //int num2 = Integer.parseInt(XMJSONPath.readPath(bodyJson2,"$.result.courseBenefit.leftPurchaseBalance"));
        //Assert.assertTrue(num1 == num2+1);//手动扣次后减少一次


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("consumeRecordId",consumeRecordId);
        jsonObject.put("memberCardId",memberCardId);
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());
        xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
        cardTools.fetchPageOfConsumeRecord(benefitId,memberCardId);

        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].consumeType").equals("DISCARD_MANUAL_DEDUCT"),"操作手动扣次，消耗记录第一条操作类型");
        Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].changeOfPurchaseBalance").equals("1.00"),"操作撤销手动扣次，消耗次数");

        //JSONObject bodyJson3 =Cardtools.memberCardFindDetailById(memberCardId);
        //int num3 = Integer.parseInt(XMJSONPath.readPath(bodyJson2,"$.result.courseBenefit.leftPurchaseBalance"));
        //Assert.assertTrue(num1 == num3);//撤销后和原来一样的次数

    }
}
