package com.xiaomai.cases.polar.finance.cashier;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestGetXmPayResult extends XMBaseTest {


    CashierTools cashierTools=new CashierTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Finance)
                .setApiName("API_getXmPayResult")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }


    @Test(description = "查询订单使用小麦收银支付结果-收款成功")
    public  void testGetXmPayResult_PAY_SUCCESS(){

        //写死的关联订单支付成功的流水：1809061860383899650；必须是关联订单的,不能解除
        JSONObject jsonObject=new JSONObject();
        jsonObject.put("id","1809061860383899650");//关联订单支付成功的流水；必须是关联订单的,不能解除
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        String success=xmAppApi.getBodyInJSON().getString("success");
        String transState=xmAppApi.getBodyInJSON().getJSONObject("result").getString("transState");
        Assert.assertEquals(success,"true","查询订单使用小麦收银支付结果失败");
        Assert.assertEquals(transState,"PAY_SUCCESS","支付成功流水状态未是支付成功");
    }


    @Test(description = "查询订单使用小麦收银支付结果-退款成功")
    public  void testGetXmPayResult_REFUND_SUCCESS(){

        //获取交易记录（流水）列表
        JSONObject result=cashierTools.page_sift("WX","REFUND_ORDER","REFUND_SUCCESS");
        int total=Integer.parseInt(result.getJSONObject("result").getString("total"));

        if(total>0){
            String id=result.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");//流水ID
            //查询订单使用小麦收银支付结果
            JSONObject jsonObject=new JSONObject();
            jsonObject.put("id",id);
            jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

            xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
            String success=xmAppApi.getBodyInJSON().getString("success");
            String transState=xmAppApi.getBodyInJSON().getJSONObject("result").getString("transState");
            Assert.assertEquals(success,"true","查询订单使用小麦收银支付结果失败");
            Assert.assertEquals(transState,"REFUND_SUCCESS","退款成功流水状态未是退款成功");
        }

    }


    @Test(description = "查询订单使用小麦收银支付结果-退款失败")
    public  void testGetXmPayResult_REFUND_FAIL(){

        //获取交易记录（流水）列表
        JSONObject result=cashierTools.page_sift("WX","REFUND_ORDER","REFUND_FAIL");
        int total=Integer.parseInt(result.getJSONObject("result").getString("total"));

        if(total>0) {
            String id=result.getJSONObject("result").getJSONArray("records").getJSONObject(0).getString("id");//流水ID
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", id);//退款失败
            jsonObject.put("brandId", xmAppApi.getLoginInfo().getBrandId());
            jsonObject.put("studioId", xmAppApi.getLoginInfo().getStudioId());
            jsonObject.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

            xmAppApi.doRequest(RequestType.JSON, params, jsonObject.toJSONString(), headers).assetsSuccess(true);
            String success = xmAppApi.getBodyInJSON().getString("success");
            String transState = xmAppApi.getBodyInJSON().getJSONObject("result").getString("transState");
            Assert.assertEquals(success, "true", "查询订单使用小麦收银支付结果失败");
            Assert.assertEquals(transState, "REFUND_FAIL", "退款失败流水状态未是退款失败");
        }
    }

}
