package com.xiaomai.cases.polar.setting.pay;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestSave extends XMBaseTest {


    PayTools payTools=new PayTools();

    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_Setting)
                .setApiName("API_save")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("yff")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "新建自定义支付方式")
    public void testSave(){

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("category","PAYMENT");
        jsonObject.put("name", RandomStringUtil.random_name());
        jsonObject.put("tenantId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("tenantType","BRAND");// "BRAND", "STUDIO", "INVALID" ]租户类型：BRAND-品牌；STUDIO-场馆[TenantTypeEnum]
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(true);
        JSONObject response=xmAppApi.getBodyInJSON();
        String success=response.getString("success");
        String id=response.getString("result");
        Assert.assertEquals(success,"true","新建自定义支付方式失败");

        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }


        //获取支付方式列表
        JSONArray getList=payTools.getList().getJSONArray("result");
        int length = getList.size();
        JSONObject lastJsonObject = getList.getJSONObject(length - 1);
        String lastCode=lastJsonObject.getString("code");
        String lastId=lastJsonObject.getString("id");
        Assert.assertEquals(lastId.equals(id),true,"新建自定义支付方式失败");


        //校验该支付方式是否使用过
        boolean checkPaymentWayUsedResult=payTools.checkPaymentWayUsed(id,lastCode).getBoolean("result");

        if(checkPaymentWayUsedResult == false){

            //删除新建的自定义支付方式
            JSONObject removeResult=payTools.remove(id);
            Assert.assertEquals(removeResult.getString("success"),"true","删除新建自定义支付方式失败");
        }

    }

    @Test(description = "新建自定义支付方式-不可添加重复名称")
    public void testSave_duplicateName(){

        JSONObject jsonObject=new JSONObject();
        jsonObject.put("category","PAYMENT");
        jsonObject.put("name","线下支付宝");
        jsonObject.put("tenantId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("tenantType","BRAND");
        jsonObject.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        jsonObject.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        jsonObject.put("operatorId",xmAppApi.getLoginInfo().getAdminId());

        xmAppApi.doRequest(RequestType.JSON,params,jsonObject.toJSONString(),headers).assetsSuccess(false);

    }



}
