package com.xiaomai.cases.polar.memberCard;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.polar.finance.order.OrderTools;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import javax.annotation.Resource;

/**
 * 售卖记录详情-会员卡开卡
 *
 * @author adu
 * data 2024/7/24 14:43
 */

public class TestActivateMemberCard extends GetMemberCardBaseInfoForSign {
    @Resource(name = "cardTools")
    CardTools cardTools;
    @Resource(name = "orderTools")
    OrderTools orderTools;
    @BeforeClass
    public void beforeTest() {
        setTestInfo(ApiModule.Polar_Card, "API_activateMemberCard", LoginAccount.ADU_PROD, Terminal.B, "adu");
        super.beforeTest();
    }

    @Test(description = "操作会员卡开卡")
    public void testActivateMemberCard() {
        cardTools.getUserMemberCardList(memberId);
        String memberAccountCardId="";
        String state;
        int count= XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result").size();
        if(count>0){
            memberAccountCardId=XMJSONPath.readPath(dataApi.getApi_response(),"$.result[0].id");
            state=XMJSONPath.readPath(dataApi.getApi_response(),"$.result[0].state");
            if(state.equals("UN_ACTIVE")){
                //操作开卡
                JSONObject body = new JSONObject();
                body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());
                body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
                body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
                body.put("memberCardId", memberAccountCardId);
                xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers).assetsSuccess(true);

                //查看售卖记录详情
                cardTools.membercardfindDetailById(memberAccountCardId);
                Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.state"),"NORMAL","开卡后卡状态没变更为生效状态");
                String benefitId=XMJSONPath.readPath(dataApi.getApi_response(),"$.result.benefitList[0].id");

                //check生成一条变动记录
                cardTools.getMemberCardAccountOperateRecord(memberAccountCardId);
                Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].operateType").equals("ACTIVATE"),"手动开卡后生成的变动记录第一条备注不是手动开卡ACTIVATE");
                Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].remark").equals("手动开卡"),"手动开卡后生成的变动记录第一条备注不是手动开卡");

                //查看消耗记录
                cardTools.fetchPageOfConsumeRecord(benefitId,memberAccountCardId);
                int totalBefore=XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.records").size();
                Assert.assertTrue(totalBefore==1,"会员购卡后没生成购买的消耗记录");
                Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].consumeType").equals("PURCHASE"),"会员购卡后生成消耗记录不是购买");

                //操作退卡
                orderTools.refundOrder(2,memberAccountCardId,quantity,price,"MEMBER_CARD",
                        memberId,price,price,"1");

               String refundOrderId=XMJSONPath.readPath(dataApi.getApi_response(),"$.result");

                //退卡成功后check 售卖记录详情状态：已退卡
                cardTools.membercardfindDetailById(memberAccountCardId);
                Assert.assertEquals(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.state"),"REFUNDED","退卡后卡卡账户状态没变更为已退卡状态");
                //退卡后check是否生成一条退卡的消耗记录
                cardTools.fetchPageOfConsumeRecord(benefitId,memberAccountCardId);
                int totalAfter=XMJSONPath.getJSONArrayByReadPath(dataApi.getApi_response(),"$.result.records").size();
                Assert.assertTrue(totalAfter==2,"会员退卡后没生成购买的消耗记录");
                Assert.assertTrue(XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].consumeType").equals("REFUND"),"会员退卡后生成消耗记录不是退卡");
                //check 消耗次数
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].changeOfPurchaseBalance"),"-60.00","购买次数变动不是-60");
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].changeOfUsablePurchaseBalance"),"-60.00","可用次数变动不是-2");
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].changeOfGiveBalance"),"-2.00","赠送次数变动不是-60");
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].changeOfUsableGiveBalance"),"-2.00","可用赠送次数变动不是-2");
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].changeOfBenefitAmount"),"-398.00","变动金额不是-398.00");
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].leftBenefitAmount"),"0.00","剩余金额不是0.00");
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].leftPurchaseBalance"),"0.00","剩余购买次数不是0");
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].leftUsablePurchaseBalance"),"0.00","剩余可用次数不是0");
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].leftGiveBalance"),"0.00","剩余赠送次数不是0");
                Assert.assertEquals( XMJSONPath.readPath(dataApi.getApi_response(),"$.result.records[0].leftUsableGiveBalance"),"0.00","剩余可用赠送次数不是0");


            }


        }




    }
}

    