package com.xiaomai.cases.polar.admin;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @BelongsProject: xm-sportstest
 * @BelongsPackage: com.xiaomai.cases
 * @Author: xuyamei
 * @CreateTime: 2024-02-26  15:34
 * @Description: 员工
 * @Version: 1.0
 */
public class TestGetAdmin extends XMBaseTest {
    @BeforeMethod
    public void beforeTest() {
        xmAppApi.setApiModule(ApiModule.Polar_Admin) // API 所属模块
                .setApiName("API_getAdmin")
                .setLoginUser(LoginAccount.XYM_DEV)         // http 接口，测试账号
                .setTerminal(Terminal.B);             // 所属端位（B端，C端，M端等, 必传）
        dal.setCase_owner("xym")
                .setCase_name( Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test
    public void testGetAdmin(){
        String body = "{\"id\":\"1760544702379651074\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers);
        JSONObject response = xmAppApi.getBodyInJSON();
        System.out.println("-------:"+response);
    }
}
