package com.xiaomai.cases.polar.applet;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMBaseTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/1 16:46
 */
public class TestGenerateTicket extends XMBaseTest {
    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Lunar_Share)
                .setApiName("API_generateTicket")
                .setLoginUser(LoginAccount.GYM_MINIAPPC)
                .setTerminal(Terminal.minApp);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    @Test(description = "存储参数获取ticket")
    public void testGenerateTicket(){

        JSONObject paramJson = new JSONObject();
        paramJson.put("brandId",xmAppApi.getLoginInfo().getBrandId());
        paramJson.put("studioId",xmAppApi.getLoginInfo().getStudioId());
        paramJson.put("id",xmAppApi.getLoginInfo().getStudioId());

        JSONObject object = new JSONObject();
        object.put("paramJson",paramJson);

        xmAppApi.doRequest(RequestType.JSON,params,object.toString(),headers).assetsSuccess(true);

    }

}
