package com.xiaomai.cases.polar.luckyDraw;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestPrizeScanCode extends XMBaseTest {
    @Resource(name = "luckyDrawTools")
    LuckyDrawTools luckyDrawTools;
    @Resource(name = "userTools")
    UserTools userTools;
    DataUserInfo info = new DataUserInfo();
    public String prizeId;
    public String prizeName = "自定义奖品";;
    @BeforeMethod
    public void beforeTest(){
        xmAppApi.setApiModule(ApiModule.Polar_LuckyDraw)
                .setApiName("API_prizeScanCode")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);
        dal.setCase_owner("xyy")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();

    }
    @Test(description = "扫幸运抽奖活动的兑奖二维码进行兑奖")
    public void testPrizeScanCod()throws InterruptedException{
        info.setTerminal(Terminal.minApp);
        info.setLoginUser(LoginAccount.GYM_MINIAPPC);
        //查询自定义奖品数量
        int total = Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getCustomizePrizeByPage("自定义奖品"),"$.result.total"));
        if(total==0){
            //创建1个自定义奖品
            prizeId = luckyDrawTools.addCustomizePrize(prizeName);
        }
        prizeId = XMJSONPath.readPath(luckyDrawTools.getCustomizePrizeByPage("自定义奖品"),"$.result.records[0].id");

        //创建活动名称
        String activityName = "每人每天抽自定义奖品" + RandomStringUtil.randomString(5);
        //创建活动=未开始
        Thread.sleep(5000);
        String activityId = luckyDrawTools.addLuckyDraw("CUSTOMIZE_GIFT",prizeName,prizeId,true,activityName);
        Thread.sleep(1000);
        String prizeNo = XMJSONPath.readPath(luckyDrawTools.getLuckyDrawDetail(activityId),"$.result.prizeList[0].id");
        //编辑活动=进行中（主要是改活动开始时间）
        luckyDrawTools.editLuckyDraw("CUSTOMIZE_GIFT",prizeNo,prizeName,prizeId,true,activityId,activityName);
        //获取会员信息
        String memberId = userTools.getMemberInfo(info).getString("memberId");
        int drawNum = luckyDrawTools.getDrawNum(activityId,memberId,info);//抽奖次数
        //开始抽奖, 总共抽2次，获奖2次：一次手动兑换，一次扫码兑换
        for (int i = 0; i < 2; i++) {
            //100%中奖
            Thread.sleep(5000);
            Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.luckyDrawLottery(activityId,memberId,info),"$.result.winPrize"),"true");
        }
        //抽奖次数-2
        Assert.assertTrue(luckyDrawTools.getDrawNum(activityId,memberId,info)==drawNum-2);
        //我的奖品+2
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getMyActPrizeByPage(activityId,memberId,info),"$.result.total"))==2);

        //app奖品消耗，参与记录
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyPrizeCount(activityId),"$.result[0].winCount"))==2);//已抽中2个
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyPrizeCount(activityId),"$.result[0].stock"))==98);//剩余98个
        //app参与记录
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(luckyDrawTools.getLuckyAttendByPage(activityId),"$.result.total"))==2);//参与记录2条
        Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.getLuckyAttendByPage(activityId),"$.result.records[0].sendState"),"NOT_SENT");//待兑奖状态
        String sendRecordId = XMJSONPath.readPath(luckyDrawTools.getLuckyAttendByPage(activityId),"$.result.records[0].sendRecordId");
        //扫兑奖码
        JSONObject body = new JSONObject();
        body.put("id",sendRecordId);
        body.put("brandId", xmAppApi.getLoginInfo().getBrandId());
        body.put("studioId", xmAppApi.getLoginInfo().getStudioId());
        body.put("operatorId", xmAppApi.getLoginInfo().getAdminId());

        //调用请求
        xmAppApi.doRequest(RequestType.JSON, params, body.toJSONString(), headers).assetsSuccess(true);
        //检验扫码兑换时的状态及兑奖信息准确性
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.message"),"操作成功!");
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.prizeId"),prizeId);
        Assert.assertEquals(XMJSONPath.readPath(xmAppApi.getBodyInJSON(),"$.result.receivedMemberId"),memberId);

        //进行兑奖,并且成功
        Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.exchangePrize(sendRecordId),"$.message"),"操作成功!");
        //校验兑奖信息状态=已兑奖
        Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.getRewardSendDetail(sendRecordId),"$.result.sendState"),"SENT");//已兑奖状态
        Assert.assertEquals(XMJSONPath.readPath(luckyDrawTools.getRewardSendDetail(sendRecordId),"$.result.prizeType"),"CUSTOMIZE_GIFT");//自定义奖品
    }
}
