package com.xiaomai.cases.polar.training;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.basetest.BaseTestImpl;
import com.xiaomai.cases.lunar.user.UserTools;
import com.xiaomai.client.DataUserInfo;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.XMJSONPath;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.annotation.Resource;

public class TestAiChat extends BaseTestImpl {
    @Resource(name="trainingTools")
    TrainingTools trainingTools;
    @Resource(name="userTools")
    UserTools userTools;
    DataUserInfo info = new DataUserInfo();
    String memberId;
    @BeforeMethod
    @Override
    public void beforeTest(){
        setTestInfo(ApiModule.Polar_Training, "API_aiChat", LoginAccount.GYM_PROD, Terminal.B, "xyy");
        super.beforeTest();
    }

    @Test(description = "获取AI小助理>进入日常会话>获取场景历史数据>进行AI聊天>清除聊天上下文>删除聊天记录")
    public void testGetTrainingPlanContent() throws InterruptedException {
        //1.获取日常问答的modelId，personModelId
        String modelId = XMJSONPath.readPath(trainingTools.listModelPerson(),"$.result[0].modelId");
        String personModelId = XMJSONPath.readPath(trainingTools.listModelPerson(),"$.result[0].id");

        //2.获取日常问答的会话id
        String conversationId = trainingTools.getAiConversationId(modelId,personModelId);

        //3.查询当前会话的历史数据
        int num = Integer.parseInt(XMJSONPath.readPath(trainingTools.getConversationMessagePage(conversationId),"$.result.total"));

        JSONObject body = new JSONObject();
        body.put("conversationId",conversationId);
        body.put("question","你好");

        //调用请求
        xmAppApi.doRequest(RequestType.JSON, params, body.toString(), headers);
        Thread.sleep(2000);
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.getConversationMessagePage(conversationId),"$.result.total"))==num+2);

        //4.清除聊天上下文
        trainingTools.clearConversationContext(conversationId);
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.getConversationMessagePage(conversationId),"$.result.total"))==num+2);

        //5.删除聊天记录
        trainingTools.clearConversationHistory(conversationId);
        Assert.assertTrue(Integer.parseInt(XMJSONPath.readPath(trainingTools.getConversationMessagePage(conversationId),"$.result.total"))==0);
    }
}
