package com.xiaomai.cases.polar.applet;

import com.alibaba.fastjson.JSONObject;
import com.xiaomai.enums.ApiModule;
import com.xiaomai.enums.LoginAccount;
import com.xiaomai.enums.RequestType;
import com.xiaomai.enums.Terminal;
import com.xiaomai.utils.RandomStringUtil;
import com.xiaomai.utils.XMBaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * @Author zxy
 * @Description
 * @Date 2024/7/1 16:43
 */
public class TestSetPageConfig extends XMBaseTest {
    AppletTools appletTools = new AppletTools();

    @BeforeMethod
    public void beforeTest(){

        xmAppApi.setApiModule(ApiModule.Polar_Applet)
                .setApiName("API_setPageConfig")
                .setLoginUser(LoginAccount.GYM_PROD)
                .setTerminal(Terminal.B);

        dal.setCase_owner("zyx")
                .setCase_name(Thread.currentThread().getStackTrace()[1].getFileName().split("\\.")[0]);
        super.beforeTest();
    }

    //@Test(description = "修改小程序页面配置-首页")
    public void testSetStyleConfig(){
        String shareText = "自动化脚本首页分享"+RandomStringUtil.randomString(5);

        String body = "{\"tenantId\":\"1800375402938871809\",\"tenantType\":\"STUDIO\",\"config\":{\"shareSetting\":{\"shareText\":\""+shareText+"\",\"shareUrl\":\"\",\"selected\":\"DEFAULT\"},\"moduleConfigList\":[{\"moduleEnum\":\"CAROUSEL\",\"config\":{\"swipers\":[{\"imgUrl\":\"https://fit-resource-pub.xiaomai5.com/fitness/1796482011391729666/BRAND/applet/20240701162813/ntWh63SyKHm4mMsC.jpeg\",\"skipLink\":{\"id\":\"1796482250721169409\",\"type\":\"COACH\"}},{\"imgUrl\":\"https://fit-resource-pub.xiaomai5.com/fitness/1796482011391729666/BRAND/applet/20240701162842/3xkNQtYKH7C6kXnZ.jpeg\"}],\"height\":152}},{\"entries\":[{\"code\":\"STUDIO_INTRO\",\"title\":\"场馆介绍\"},{\"code\":\"BRAND_STORY\",\"title\":\"品牌故事\"},{\"code\":\"COACH_TEAM\",\"title\":\"教练团队\"},{\"code\":\"BOOK_LESSON\",\"title\":\"预约课程\"},{\"code\":\"MEMBER_CARD\",\"title\":\"会员卡\"},{\"code\":\"EXPERIENCE_CARD\",\"icon\":\"\",\"title\":\"体验卡\"}],\"moduleEnum\":\"GRAPHIC_NAVIGATION\",\"config\":{\"entries\":[{\"code\":\"STUDIO_INTRO\",\"title\":\"场馆介绍\"},{\"code\":\"BRAND_STORY\",\"title\":\"品牌故事\"},{\"code\":\"COACH_TEAM\",\"title\":\"教练团队\"},{\"code\":\"BOOK_LESSON\",\"title\":\"预约课程\"},{\"code\":\"MEMBER_CARD\",\"title\":\"会员卡\"},{\"code\":\"EXPERIENCE_CARD\",\"icon\":\"\",\"title\":\"体验卡\"}],\"lineNum\":4}},{\"moduleEnum\":\"STUDIO_INTRO\",\"config\":{\"layout\":\"BIG\"}},{\"moduleEnum\":\"BRAND_STORY\",\"config\":{\"title\":\"品牌故事\"}},{\"moduleEnum\":\"COACH_TEAM\",\"config\":{\"layout\":\"SCROLL\",\"limitNum\":4,\"dataType\":\"DEFAULT\",\"ids\":[],\"coachInfo\":{\"proficients\":true,\"teachingStyles\":true,\"intro\":true,\"skillCertifications\":true},\"title\":\"教练团队\"}},{\"moduleEnum\":\"RECOMMEND_GROUP_LESSON\",\"config\":{\"layout\":\"SCROLL\",\"limitNum\":4,\"dataType\":\"DEFAULT\",\"title\":\"推荐团课\"}},{\"moduleEnum\":\"MEMBER_CARD\",\"config\":{\"layout\":\"SCROLL\",\"limitNum\":4,\"dataType\":\"DEFAULT\",\"title\":\"会员卡\"}},{\"moduleEnum\":\"RECOMMENT_PRIVATE_LESSON\",\"config\":{\"layout\":\"SCROLL\",\"limitNum\":4,\"dataType\":\"DEFAULT\",\"ids\":[],\"title\":\"推荐私教课\"}},{\"moduleEnum\":\"TRAINING_CAMP\",\"config\":{\"layout\":\"SCROLL\",\"limitNum\":4,\"dataType\":\"DEFAULT\",\"ids\":[],\"title\":\"推荐训练营\"}},{\"moduleEnum\":\"EXPERIENCE_CARD\",\"config\":{\"layout\":\"SCROLL\",\"limitNum\":4,\"dataType\":\"DEFAULT\",\"ids\":[],\"title\":\"体验卡\"}}],\"bgSetting\":{\"swipers\":[],\"bgColor\":\"\",\"selected\":\"DEFAULT\",\"bgUrl\":\"https://image.xiaomaiketang.com/xm/internal/TRcJHBMjyj.png\",\"height\":200},\"promotion\":[]},\"pageKey\":\"HOME\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);

        Assert.assertEquals(appletTools.getPageConfig("HOME").getJSONObject("result").getJSONObject("shareSetting").getString("shareText"),shareText);
    }

    //@Test(description = "修改小程序页面配置-约课")
    public void testSetStyleConfig_1(){
        String shareText = "自动化脚本约课页面分享"+RandomStringUtil.randomString(5);

        String body = "{\"tenantId\":\"1800375402938871809\",\"tenantType\":\"STUDIO\",\"config\":{\"shareSetting\":{\"shareText\":\""+shareText+"\",\"shareUrl\":\"\",\"selected\":\"DEFAULT\"},\"listStyle\":\"TEACHER\",\"bgSetting\":{\"selected\":\"DEFAULT\",\"bgUrl\":\"https://image.xiaomaiketang.com/xm/internal/TRcJHBMjyj.png\"},\"bookType\":[{\"code\":\"GROUP_LESSON\",\"visible\":true,\"title\":\"团课\"},{\"code\":\"PRIVATE_LESSON\",\"visible\":true,\"title\":\"私教\"},{\"code\":\"BOOTCAMP\",\"visible\":true,\"title\":\"训练营\"}]},\"pageKey\":\"CLASS\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        Assert.assertEquals(appletTools.getPageConfig("CLASS").getJSONObject("result").getJSONObject("shareSetting").getString("shareText"),shareText);

    }

    //@Test(description = "修改小程序页面配置-我的")，json一直在更新，每次上线后脚本的json不更新就会产生脏数据，先注释掉
    public void testSetStyleConfig_2(){

        String shareText = "自动化脚本我的页面分享"+RandomStringUtil.randomString(5);

        String body = "{\"tenantId\":\"1800375402938871809\",\"tenantType\":\"STUDIO\",\"config\":{\"shareSetting\":{\"shareText\":\""+shareText+"\",\"shareUrl\":\"\"},\"memberAssets\":[{\"code\":\"MEMBER_CARD\",\"visible\":true,\"title\":\"会员卡\"},{\"code\":\"EXPERIENCE_CARD\",\"visible\":true,\"title\":\"体验卡\"},{\"code\":\"TRAINING_CAMP\",\"visible\":true,\"title\":\"训练营\"}],\"bgSetting\":{\"selected\":\"DEFAULT\",\"bgUrl\":\"https://image.xiaomaiketang.com/xm/internal/TRcJHBMjyj.png\"},\"commonlyEntry\":[{\"code\":\"MY_ORDER\",\"visible\":true,\"title\":\"我的订单\"},{\"code\":\"MY_BOOKING\",\"visible\":true,\"title\":\"我的预约\"},{\"code\":\"SCAN_CODE_SIGNIN\",\"visible\":true,\"title\":\"扫码签到\"}]},\"pageKey\":\"MINE\"}";
        xmAppApi.doRequest(RequestType.JSON,params,body,headers).assetsSuccess(true);
        Assert.assertEquals(appletTools.getPageConfig("MINE").getJSONObject("result").getJSONObject("shareSetting").getString("shareText"),shareText);

    }
}
